/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class DeploymentUnitImpl
extends SimpleAttachable
implements DeploymentUnit {
    private final DeploymentUnit parent;
    private final String name;
    private final ServiceRegistry serviceRegistry;

    DeploymentUnitImpl(DeploymentUnit parent, String name, ServiceRegistry serviceRegistry) {
        this.parent = parent;
        this.name = name;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public ServiceName getServiceName() {
        if (this.parent != null) {
            return Services.deploymentUnitName(this.parent.getName(), this.name);
        }
        return Services.deploymentUnitName(this.name);
    }

    @Override
    public DeploymentUnit getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public String toString() {
        if (this.parent != null) {
            return String.format("subdeployment \"%s\" of %s", this.name, this.parent);
        }
        return String.format("deployment \"%s\"", this.name);
    }
}

