/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.function.Function;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.Dependency;

public interface ServiceDependency<V>
extends Dependency<ServiceBuilder<?>, V> {
    default public <R> ServiceDependency<R> map(final Function<V, R> mapper) {
        return new ServiceDependency<R>(){

            @Override
            public void accept(ServiceBuilder<?> builder) {
                ServiceDependency.this.accept(builder);
            }

            @Override
            public R get() {
                return mapper.apply(ServiceDependency.this.get());
            }
        };
    }

    public static <V> ServiceDependency<V> of(V value) {
        return value != null ? new SimpleServiceDependency<V>(value) : SimpleServiceDependency.NULL;
    }

    public static <V> ServiceDependency<V> on(ServiceName name) {
        return name != null ? new DefaultServiceDependency(name) : ServiceDependency.of(null);
    }

    public static class DefaultServiceDependency<V>
    extends Dependency.DefaultDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        DefaultServiceDependency(ServiceName name) {
            super(name);
        }
    }

    public static class SimpleServiceDependency<V>
    extends Dependency.SimpleDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        static final ServiceDependency<Object> NULL = new SimpleServiceDependency<Object>(null);

        SimpleServiceDependency(V value) {
            super(value);
        }
    }
}

