/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service.capture;

import java.util.function.Consumer;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutor;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ResourceServiceValueRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public interface ResourceServiceValueExecutorRegistry<V>
extends ResourceServiceValueRegistry<V>,
FunctionExecutorRegistry<V> {
    public static <V> ResourceServiceValueExecutorRegistry<V> create() {
        final ServiceValueExecutorRegistry registry = ServiceValueExecutorRegistry.create();
        return new ResourceServiceValueExecutorRegistry<V>(){

            @Override
            public ServiceInstaller capture(final ServiceDependency<V> dependency) {
                Consumer startTask = new Consumer<V>(){

                    @Override
                    public void accept(V value) {
                        registry.add(dependency).accept(value);
                    }
                };
                Consumer stopTask = new Consumer<V>(){

                    @Override
                    public void accept(V value) {
                        registry.remove(dependency);
                    }
                };
                return (ServiceInstaller)((ServiceInstaller.Builder)((ServiceInstaller.Builder)((ServiceInstaller.Builder)ServiceInstaller.builder(dependency).onStart(startTask)).onStop(stopTask)).asPassive()).build();
            }

            @Override
            public FunctionExecutor<V> getExecutor(ServiceDependency<V> dependency) {
                return registry.getExecutor(dependency);
            }
        };
    }
}

