/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.operation;

import java.util.Set;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.operation.OperationStepHandlerDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;

public class RemoveResourceOperationStepHandler
extends AbstractRemoveStepHandler {
    private final OperationStepHandlerDescriptor descriptor;

    public RemoveResourceOperationStepHandler(OperationStepHandlerDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && this.descriptor.getRuntimeHandler().isPresent();
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (RemoveResourceOperationStepHandler.removeInCurrentStep(resource)) {
            PathAddress address = context.getCurrentAddress();
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            for (RuntimeCapability capability : registration.getCapabilities()) {
                if (!this.descriptor.getCapabilityFilter(capability).test(context, resource)) continue;
                context.deregisterCapability((capability.isDynamicallyNamed() ? capability.fromBaseCapability(address) : capability).getName());
            }
            for (AttributeAccess attribute : registration.getAttributes(PathAddress.EMPTY_ADDRESS).values()) {
                if (AttributeAccess.Storage.RUNTIME.test(attribute) || AttributeAccess.Flag.ALIAS.test(attribute)) continue;
                AttributeDefinition definition = attribute.getAttributeDefinition();
                String attributeName = definition.getName();
                if (!definition.hasCapabilityRequirements()) continue;
                definition.removeCapabilityRequirements(context, resource, model.get(attributeName));
            }
            for (CapabilityReferenceRecorder recorder : registration.getRequirements()) {
                recorder.removeCapabilityRequirements(context, resource, null, new String[0]);
            }
        }
        super.performRemove(context, operation, model);
    }

    private static boolean removeInCurrentStep(Resource resource) {
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                if (entry.isRuntime() || !resource.hasChild(entry.getPathElement())) continue;
                return false;
            }
        }
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Set flags = context.getResourceRegistration().getOperationFlags(PathAddress.EMPTY_ADDRESS, context.getCurrentOperationName());
        if (flags.contains(OperationEntry.Flag.RESTART_NONE) || flags.contains(OperationEntry.Flag.RESTART_RESOURCE_SERVICES) && context.isResourceServiceRestartAllowed()) {
            ResourceOperationRuntimeHandler handler = this.descriptor.getRuntimeHandler().orElse(null);
            if (handler != null) {
                handler.removeRuntime(context, model);
            }
        } else if (flags.contains(OperationEntry.Flag.RESTART_JVM)) {
            context.restartRequired();
        } else {
            context.reloadRequired();
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Set flags = context.getResourceRegistration().getOperationFlags(PathAddress.EMPTY_ADDRESS, context.getCurrentOperationName());
        if (flags.contains(OperationEntry.Flag.RESTART_NONE) || flags.contains(OperationEntry.Flag.RESTART_RESOURCE_SERVICES) && context.isResourceServiceRestartAllowed()) {
            ResourceOperationRuntimeHandler handler = this.descriptor.getRuntimeHandler().orElse(null);
            if (handler != null) {
                handler.addRuntime(context, model);
            }
        } else if (flags.contains(OperationEntry.Flag.RESTART_JVM)) {
            context.revertRestartRequired();
        } else {
            context.revertReloadRequired();
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
    }
}

