/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import org.wildfly.extras.transformer.ArchiveTransformer;
import org.wildfly.extras.transformer.TransformerBuilder;
import org.wildfly.extras.transformer.TransformerFactory;

final class HandleTransformation {
    public static final String JAR_FILE_EXT = ".jar";

    HandleTransformation() {
    }

    static void transformDirectory(File folder, File targetFolder, String configsDir, boolean verbose, boolean overwrite, boolean invert) throws IOException {
        HandleTransformation.transformDirectory(folder, targetFolder, configsDir, verbose, overwrite, invert, Collections.emptySet());
    }

    static void transformDirectory(File folder, File targetFolder, String configsDir, boolean verbose, boolean overwrite, boolean invert, Set<String> ignored) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File sourceFile : files) {
            File targetFile = new File(targetFolder, sourceFile.getName());
            if (sourceFile.isDirectory()) {
                HandleTransformation.transformDirectory(sourceFile, new File(targetFolder, sourceFile.getName()), configsDir, verbose, overwrite, invert, ignored);
                continue;
            }
            if (targetFile.exists()) {
                if (!overwrite) continue;
                targetFile.delete();
                HandleTransformation.transformFile(sourceFile, new File(targetFolder, sourceFile.getName()), configsDir, verbose, invert, ignored);
                continue;
            }
            HandleTransformation.transformFile(sourceFile, new File(targetFolder, sourceFile.getName()), configsDir, verbose, invert, ignored);
        }
    }

    static void transformFile(File sourceFile, File targetFile, String configsDir, boolean verbose, boolean invert) throws IOException {
        HandleTransformation.transformFile(sourceFile, targetFile, configsDir, verbose, invert, Collections.emptySet());
    }

    static void transformFile(File sourceFile, File targetFile, String configsDir, boolean verbose, boolean invert, Set<String> ignored) throws IOException {
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("input file " + sourceFile.getName() + " does not exist");
        }
        String path = sourceFile.getPath();
        for (String ignore : ignored) {
            if (!path.endsWith(ignore)) continue;
            return;
        }
        TransformerBuilder builder = TransformerFactory.getInstance().newTransformer();
        if (configsDir != null) {
            builder.setConfigsDir(configsDir);
        }
        builder.setVerbose(verbose);
        builder.setInvert(invert);
        ArchiveTransformer transformer = builder.build();
        if (!transformer.canTransformIndividualClassFile() && !sourceFile.getName().endsWith(JAR_FILE_EXT)) {
            throw new IllegalArgumentException("Supported file extensions are .jar : " + sourceFile.getAbsolutePath());
        }
        Files.createDirectories(targetFile.toPath().getParent(), new FileAttribute[0]);
        transformer.transform(sourceFile, targetFile);
    }
}

