/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.deployments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class Deploy
implements OnlineCommand {
    private final String deploymentName;
    private final InputStream deploymentInputStream;
    private final boolean autoCloseInputStream;
    private final List<String> serverGroups;

    private Deploy(InputStream deploymentInputStream, Builder deployCmdOptions) {
        this.deploymentInputStream = deploymentInputStream;
        this.deploymentName = deployCmdOptions.deploymentName;
        this.autoCloseInputStream = deployCmdOptions.autoCloseInputStream;
        this.serverGroups = deployCmdOptions.serverGroups;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        ModelNode deployRequest;
        Operations ops = new Operations(ctx.client);
        ModelNode content = new ModelNode();
        content.get("input-stream-index").set(0);
        if (ctx.options.isDomain) {
            List groups = this.serverGroups;
            if (this.serverGroups == null) {
                groups = ops.readChildrenNames(Address.root(), "server-group").stringListValue(Collections.emptyList());
            }
            ArrayList<ModelNode> groupDeploymentAddresses = new ArrayList<ModelNode>(groups.size());
            for (String serverGroup : groups) {
                ModelNode mn = new ModelNode();
                mn.add("server-group", serverGroup);
                mn.add("deployment", this.deploymentName);
                groupDeploymentAddresses.add(mn);
            }
            deployRequest = this.createDeploymentOperation(content, groupDeploymentAddresses.toArray(new ModelNode[groupDeploymentAddresses.size()]));
        } else {
            deployRequest = this.createDeploymentOperation(content, new ModelNode[0]);
            ModelNode deployStep = deployRequest.get("steps").add();
            ModelNode deploymentAddress = new ModelNode();
            deploymentAddress.add("deployment", this.deploymentName);
            deployStep.set(this.getEmptyOperation("deploy", deploymentAddress));
        }
        OperationBuilder builder = new OperationBuilder(deployRequest, this.autoCloseInputStream);
        builder.addInputStream(this.deploymentInputStream);
        ctx.client.execute(builder.build());
    }

    private ModelNode createDeploymentOperation(ModelNode content, ModelNode ... serverGroupAddresses) {
        ModelNode composite = this.getEmptyOperation("composite", new ModelNode().setEmptyList());
        ModelNode steps = composite.get("steps");
        ModelNode step1 = steps.add();
        step1.set(this.getEmptyOperation("add", new ModelNode().add("deployment", this.deploymentName)));
        step1.get("content").add(content);
        if (serverGroupAddresses != null) {
            for (ModelNode serverGroup : serverGroupAddresses) {
                ModelNode sg = steps.add();
                sg.set(this.getEmptyOperation("add", serverGroup));
                sg.get("enabled").set(true);
            }
        }
        return composite;
    }

    private ModelNode getEmptyOperation(String operationName, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (address != null) {
            op.get("address").set(address);
        } else {
            op.get("address");
        }
        return op;
    }

    public static final class Builder {
        private File deploymentFile;
        private InputStream deploymentInputStream;
        private final boolean autoCloseInputStream;
        private final String deploymentName;
        private List<String> serverGroups;

        public Builder(File deploymentFile) {
            if (!deploymentFile.exists()) {
                throw new IllegalArgumentException(deploymentFile + " doesn't exist!");
            }
            this.deploymentFile = deploymentFile;
            this.deploymentName = deploymentFile.getName();
            this.autoCloseInputStream = true;
        }

        public Builder(InputStream deploymentInputStream, String deploymentName, boolean autoCloseInputStream) {
            this.deploymentInputStream = deploymentInputStream;
            this.deploymentName = deploymentName;
            this.autoCloseInputStream = autoCloseInputStream;
        }

        public Deploy build() {
            InputStream inputStream = this.deploymentInputStream;
            if (this.deploymentInputStream == null && this.deploymentFile != null) {
                try {
                    inputStream = new FileInputStream(this.deploymentFile);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            return new Deploy(inputStream, this);
        }

        public Builder toServerGroups(String ... serverGroups) {
            if (this.serverGroups == null && serverGroups != null) {
                this.serverGroups = new ArrayList<String>();
            }
            if (serverGroups != null) {
                this.serverGroups.addAll(Arrays.asList(serverGroups));
            }
            return this;
        }

        public Builder toAllServerGroups() {
            this.serverGroups = null;
            return this;
        }
    }
}

