/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.tls;

import org.wildfly.extras.creaper.commands.elytron.tls.AbstractAddSSLContext;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddServerSSLContext
extends AbstractAddSSLContext {
    private final Boolean authenticationOptional;
    private final Boolean needClientAuth;
    private final Boolean wantClientAuth;
    private final Integer maximumSessionCacheSize;
    private final Integer sessionTimeout;
    private final String securityDomain;
    private final String realmMapper;
    private final String preRealmPrincipalTransformer;
    private final String postRealmPrincipalTransformer;
    private final String finalPrincipalTransformer;
    private final Boolean useCipherSuitesOrder;
    private final Boolean wrap;

    private AddServerSSLContext(Builder builder) {
        super(builder);
        this.authenticationOptional = builder.authenticationOptional;
        this.needClientAuth = builder.needClientAuth;
        this.wantClientAuth = builder.wantClientAuth;
        this.maximumSessionCacheSize = builder.maximumSessionCacheSize;
        this.sessionTimeout = builder.sessionTimeout;
        this.securityDomain = builder.securityDomain;
        this.realmMapper = builder.realmMapper;
        this.preRealmPrincipalTransformer = builder.preRealmPrincipalTransformer;
        this.postRealmPrincipalTransformer = builder.postRealmPrincipalTransformer;
        this.finalPrincipalTransformer = builder.finalPrincipalTransformer;
        this.useCipherSuitesOrder = builder.useCipherSuitesOrder;
        this.wrap = builder.wrap;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        if (this.cipherSuiteNames != null && ctx.version.lessThan(ServerVersion.VERSION_12_0_0)) {
            throw new AssertionError((Object)"cipher-suite-names attribute is available since WildFly 19");
        }
        Operations ops = new Operations(ctx.client);
        Address serverSSLContextAddress = Address.subsystem((String)"elytron").and("server-ssl-context", this.name);
        if (this.replaceExisting) {
            ops.removeIfExists(serverSSLContextAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(serverSSLContextAddress, Values.empty().and("key-manager", this.keyManager).andOptional("cipher-suite-filter", this.cipherSuiteFilter).andOptional("cipher-suite-names", this.cipherSuiteNames).andOptional("maximum-session-cache-size", this.maximumSessionCacheSize).andOptional("session-timeout", this.sessionTimeout).andOptional("trust-manager", this.trustManager).andListOptional(String.class, "protocols", this.protocols).andOptional("authentication-optional", this.authenticationOptional).andOptional("need-client-auth", this.needClientAuth).andOptional("want-client-auth", this.wantClientAuth).andOptional("security-domain", this.securityDomain).andOptional("realm-mapper", this.realmMapper).andOptional("pre-realm-principal-transformer", this.preRealmPrincipalTransformer).andOptional("post-realm-principal-transformer", this.postRealmPrincipalTransformer).andOptional("final-principal-transformer", this.finalPrincipalTransformer).andOptional("use-cipher-suites-order", this.useCipherSuitesOrder).andOptional("wrap", this.wrap).andOptional("providers", this.providers).andOptional("provider-name", this.providerName));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        if (this.cipherSuiteNames != null && ctx.version.lessThan(ServerVersion.VERSION_12_0_0)) {
            throw new AssertionError((Object)"cipher-suite-names attribute is available since WildFly 19");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddServerSSLContext.class).subtree("elytronSubsystem", Subtree.subsystem("elytron")).parameter("atrName", this.name).parameter("atrCipherSuiteFilter", this.cipherSuiteFilter).parameter("atrCipherSuiteNames", this.cipherSuiteNames).parameter("atrMaximumSessionCacheSize", this.maximumSessionCacheSize).parameter("atrSessionTimeout", this.sessionTimeout).parameter("atrKeyManager", this.keyManager).parameter("atrTrustManager", this.trustManager).parameter("atrProtocols", this.protocols != null ? this.joinList(this.protocols) : null).parameter("atrAuthenticationOptional", this.authenticationOptional).parameter("atrNeedClientAuth", this.needClientAuth).parameter("atrWantClientAuth", this.wantClientAuth).parameter("atrSecurityDomain", this.securityDomain).parameter("atrRealmMapper", this.realmMapper).parameter("atrPreRealmPrincipalTransformer", this.preRealmPrincipalTransformer).parameter("atrPostRealmPrincipalTransformer", this.postRealmPrincipalTransformer).parameter("atrFinalPrincipalTransformer", this.finalPrincipalTransformer).parameter("atrUseCipherSuitesOrder", this.useCipherSuitesOrder).parameter("atrWrap", this.wrap).parameter("atrProviders", this.providers).parameter("atrProviderName", this.providerName).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder
    extends AbstractAddSSLContext.Builder<Builder> {
        private Boolean authenticationOptional;
        private Boolean needClientAuth;
        private Boolean wantClientAuth;
        private Integer maximumSessionCacheSize;
        private Integer sessionTimeout;
        private String securityDomain;
        private String realmMapper;
        private String preRealmPrincipalTransformer;
        private String postRealmPrincipalTransformer;
        private String finalPrincipalTransformer;
        private Boolean useCipherSuitesOrder;
        private Boolean wrap;

        public Builder(String name) {
            super(name);
        }

        public Builder authenticationOptional(Boolean authenticationOptional) {
            this.authenticationOptional = authenticationOptional;
            return this;
        }

        public Builder needClientAuth(Boolean needClientAuth) {
            this.needClientAuth = needClientAuth;
            return this;
        }

        public Builder wantClientAuth(Boolean wantClientAuth) {
            this.wantClientAuth = wantClientAuth;
            return this;
        }

        public Builder maximumSessionCacheSize(Integer maximumSessionCacheSize) {
            this.maximumSessionCacheSize = maximumSessionCacheSize;
            return this;
        }

        public Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder securityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder realmMapper(String realmMapper) {
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder preRealmPrincipalTransformer(String preRealmPrincipalTransformer) {
            this.preRealmPrincipalTransformer = preRealmPrincipalTransformer;
            return this;
        }

        public Builder postRealmPrincipalTransformer(String postRealmPrincipalTransformer) {
            this.postRealmPrincipalTransformer = postRealmPrincipalTransformer;
            return this;
        }

        public Builder finalPrincipalTransformer(String finalPrincipalTransformer) {
            this.finalPrincipalTransformer = finalPrincipalTransformer;
            return this;
        }

        public Builder useCipherSuitesOrder(Boolean useCipherSuitesOrder) {
            this.useCipherSuitesOrder = useCipherSuitesOrder;
            return this;
        }

        public Builder wrap(Boolean wrap) {
            this.wrap = wrap;
            return this;
        }

        @Override
        public AddServerSSLContext build() {
            if (this.keyManager == null || this.keyManager.isEmpty()) {
                throw new IllegalArgumentException("Key-manager must be specified as non empty value");
            }
            return new AddServerSSLContext(this);
        }
    }
}

