/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.foundation.online;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.admin.ReloadToSnapshot;

public final class SnapshotBackup {
    private static final Logger log = Logger.getLogger(SnapshotBackup.class);
    private String snapshotName;
    private final OnlineCommand backupPart = new OnlineCommand(){

        public void apply(OnlineCommandContext occ) throws CommandFailedException, IOException, CliException {
            if (SnapshotBackup.this.snapshotName != null) {
                throw new CommandFailedException("Snapshot was already taken: " + SnapshotBackup.this.snapshotName);
            }
            ModelNodeResult modelNodeResult = occ.client.execute(":take-snapshot");
            modelNodeResult.assertDefinedValue("Taking snapshot failed.");
            String snaphotAbsolutePath = modelNodeResult.stringValue();
            SnapshotBackup.this.snapshotName = this.getSnapshotName(snaphotAbsolutePath);
        }

        private String getSnapshotName(String snapshotAbsolutePath) {
            if (Strings.isNullOrEmpty((String)snapshotAbsolutePath)) {
                return "";
            }
            String fileSeparator = "/";
            if (!snapshotAbsolutePath.contains("/")) {
                fileSeparator = "\\";
            }
            return snapshotAbsolutePath.substring(snapshotAbsolutePath.lastIndexOf(fileSeparator) + 1);
        }

        public String toString() {
            return "SnapshotBackup.backup";
        }
    };
    private final OnlineCommand restorePart = new OnlineCommand(){

        public void apply(OnlineCommandContext occ) throws CommandFailedException, IOException, InterruptedException, TimeoutException {
            if (SnapshotBackup.this.snapshotName == null) {
                throw new CommandFailedException("There's no snapshot to restore");
            }
            ReloadToSnapshot reloadToSnapshot = new ReloadToSnapshot(occ.client, SnapshotBackup.this.snapshotName);
            reloadToSnapshot.perform();
        }

        public String toString() {
            return "SnapshotBackup.restore";
        }
    };
    private final OnlineCommand destroyPart = new OnlineCommand(){

        public void apply(OnlineCommandContext occ) throws CliException, IOException {
            if (SnapshotBackup.this.snapshotName == null) {
                return;
            }
            occ.client.executeCli(":delete-snapshot(name=" + SnapshotBackup.this.snapshotName + ")");
            SnapshotBackup.this.snapshotName = null;
        }

        public String toString() {
            return "SnapshotBackup.destroy";
        }
    };

    public OnlineCommand backup() {
        return this.backupPart;
    }

    public OnlineCommand restore() {
        return this.restorePart;
    }

    public OnlineCommand destroy() {
        return this.destroyPart;
    }
}

