/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.AbstractPeriodicRotatingFileLogHandlerCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;

public final class ChangePeriodicRotatingFileLogHandler
extends AbstractPeriodicRotatingFileLogHandlerCommand {
    private ChangePeriodicRotatingFileLogHandler(Builder builder) {
        super(builder);
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address handlerAddress = Address.subsystem((String)"logging").and("periodic-rotating-file-handler", this.name);
        if (!ops.exists(handlerAddress)) {
            throw new IllegalStateException(String.format("periodic rotating file handler %s does not exist.", this.name));
        }
        Batch batch = new Batch();
        if (this.autoflush != null) {
            batch.writeAttribute(handlerAddress, "autoflush", this.autoflush.booleanValue());
        }
        if (this.enabled != null) {
            batch.writeAttribute(handlerAddress, "enabled", this.enabled.booleanValue());
        }
        if (this.filter != null) {
            batch.writeAttribute(handlerAddress, "filter-spec", this.filter);
        }
        if (this.encoding != null) {
            batch.writeAttribute(handlerAddress, "encoding", this.encoding);
        }
        if (this.patternFormatter != null) {
            batch.writeAttribute(handlerAddress, "formatter", this.patternFormatter);
        }
        if (this.namedFormatter != null) {
            batch.writeAttribute(handlerAddress, "named-formatter", this.namedFormatter);
        }
        if (this.level != null) {
            batch.writeAttribute(handlerAddress, "level", this.level.value());
        }
        if (this.append != null) {
            batch.writeAttribute(handlerAddress, "append", this.append.booleanValue());
        }
        if (this.suffix != null) {
            batch.writeAttribute(handlerAddress, "suffix", this.suffix);
        }
        if (this.file != null || this.fileRelativeTo != null) {
            ModelNode node = new ModelNode();
            ModelNode oldFileNode = ops.readAttribute(handlerAddress, "file", new ReadAttributeOption[0]).value();
            if (this.file != null) {
                node.get("path").set(this.file);
            } else {
                node.get("path").set(oldFileNode.get("path"));
            }
            if (this.fileRelativeTo != null) {
                node.get("relative-to").set(this.fileRelativeTo);
            } else if (oldFileNode.hasDefined("relative-to")) {
                node.get("relative-to").set(oldFileNode.get("relative-to"));
            }
            batch.writeAttribute(handlerAddress, "file", node);
        }
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(ChangePeriodicRotatingFileLogHandler.class).subtree("logging", Subtree.subsystem("logging")).parameter("name", this.name).parameter("autoflush", this.autoflush == null ? null : String.valueOf(this.autoflush)).parameter("enabled", this.enabled == null ? null : String.valueOf(this.enabled)).parameter("append", this.append == null ? null : String.valueOf(this.append)).parameter("filter", this.filter).parameter("encoding", this.encoding == null ? null : this.encoding).parameter("patternFormatter", this.patternFormatter).parameter("namedFormatter", this.namedFormatter).parameter("level", this.level == null ? null : this.level.value()).parameter("filePath", this.file).parameter("fileRelativeTo", this.fileRelativeTo).parameter("suffix", this.suffix).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "ChangePeriodicRotatingFileLogHandler " + this.name;
    }

    public static final class Builder
    extends AbstractPeriodicRotatingFileLogHandlerCommand.Builder<Builder> {
        public Builder(String name, String file, String suffix) {
            super(name, file, suffix);
        }

        @Override
        public ChangePeriodicRotatingFileLogHandler build() {
            this.validate();
            return new ChangePeriodicRotatingFileLogHandler(this);
        }
    }
}

