/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.orb;

import java.util.HashMap;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.orb.Attribute;
import org.wildfly.extras.creaper.commands.orb.AuthValues;
import org.wildfly.extras.creaper.commands.orb.OnOff;
import org.wildfly.extras.creaper.commands.orb.SecurityValues;
import org.wildfly.extras.creaper.commands.orb.SupportedValues;
import org.wildfly.extras.creaper.commands.orb.TransactionValues;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;

public final class ChangeOrb
implements OfflineCommand,
OnlineCommand {
    private static final String JACORB_SUBSYSTEM_NAME = "jacorb";
    private static final String OPENJDK_IIOP_SUBSYSTEM_NAME = "iiop-openjdk";
    private final Attribute<TransactionValues> transactions;
    private final Attribute<OnOff> supportSsl;
    private final Attribute<String> rootContext;
    private final Attribute<String> socketBinding;
    private final Attribute<String> sslSocketBinding;
    private final Attribute<AuthValues> clientRequires;
    private final Attribute<OnOff> addComponentViaInterceptor;
    private final Attribute<AuthValues> serverSupports;
    private final Attribute<String> giopVersion;
    private final Attribute<SecurityValues> security;
    private final Attribute<String> securityDomain;
    private final Attribute<AuthValues> serverRequires;
    private final Attribute<AuthValues> clientSupports;
    private final Attribute<OnOff> exportCorbaloc;
    private final Map<String, Attribute<String>> properties;
    private final Attribute<SupportedValues> integrity;
    private final Attribute<SupportedValues> confidentiality;
    private final Attribute<SupportedValues> trustInTarget;
    private final Attribute<SupportedValues> trustInClient;
    private final Attribute<SupportedValues> detectReplay;
    private final Attribute<SupportedValues> detectMisordering;
    private final Attribute<String> authMethodPassword;
    private final Attribute<String> realm;
    private final Attribute<Boolean> authRequired;
    private final Attribute<SupportedValues> callerPropagation;
    private final Attribute<String> persistentServerId;

    private ChangeOrb(Builder builder) {
        this.transactions = builder.transactions;
        this.supportSsl = builder.supportSsl;
        this.rootContext = builder.rootContext;
        this.socketBinding = builder.socketBinding;
        this.sslSocketBinding = builder.sslSocketBinding;
        this.clientRequires = builder.clientRequires;
        this.addComponentViaInterceptor = builder.addComponentViaInterceptor;
        this.serverSupports = builder.serverSupports;
        this.giopVersion = builder.giopVersion;
        this.security = builder.security;
        this.securityDomain = builder.securityDomain;
        this.serverRequires = builder.serverRequires;
        this.clientSupports = builder.clientSupports;
        this.exportCorbaloc = builder.exportCorbaloc;
        this.properties = builder.properties;
        this.integrity = builder.integrity;
        this.confidentiality = builder.confidentiality;
        this.trustInTarget = builder.trustInTarget;
        this.trustInClient = builder.trustInClient;
        this.detectReplay = builder.detectReplay;
        this.detectMisordering = builder.detectMisordering;
        this.authMethodPassword = builder.authMethodPassword;
        this.realm = builder.realm;
        this.authRequired = builder.authRequired;
        this.callerPropagation = builder.callerPropagation;
        this.persistentServerId = builder.persistentServerId;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        OrbType orbType = OrbType.get(ctx.version);
        Address address = Address.subsystem((String)orbType.subsystemName());
        if (!ops.exists(address)) {
            throw new IllegalStateException("Configuration does not support " + orbType.subsystemName() + " subsystem");
        }
        Batch batch = new Batch();
        AttributeWriter attributeWriter = new AttributeWriter(address, batch).write("root-context", this.rootContext).write("socket-binding", this.socketBinding).write("ssl-socket-binding", this.sslSocketBinding).write("security-domain", this.securityDomain).write("auth-method", this.authMethodPassword).write("realm", this.realm).write("required", this.authRequired).write("client-requires", this.clientRequires.hasValue() ? Attribute.of(this.clientRequires.get().value) : this.clientRequires).write("server-supports", this.serverSupports.hasValue() ? Attribute.of(this.serverSupports.get().value) : this.serverSupports).write("server-requires", this.serverRequires.hasValue() ? Attribute.of(this.serverRequires.get().value) : this.serverRequires).write("client-supports", this.clientSupports.hasValue() ? Attribute.of(this.clientSupports.get().value) : this.clientSupports).write("integrity", this.integrity.hasValue() ? Attribute.of(this.integrity.get().value) : this.integrity).write("confidentiality", this.confidentiality.hasValue() ? Attribute.of(this.confidentiality.get().value) : this.confidentiality).write("trust-in-target", this.trustInTarget.hasValue() ? Attribute.of(this.trustInTarget.get().value) : this.trustInTarget).write("trust-in-client", this.trustInClient.hasValue() ? Attribute.of(this.trustInClient.get().value) : this.trustInClient).write("detect-replay", this.detectReplay.hasValue() ? Attribute.of(this.detectReplay.get().value) : this.detectReplay).write("detect-misordering", this.detectMisordering.hasValue() ? Attribute.of(this.detectMisordering.get().value) : this.detectMisordering).write("caller-propagation", this.callerPropagation.hasValue() ? Attribute.of(this.callerPropagation.get().value) : this.callerPropagation);
        if (!this.properties.isEmpty()) {
            ModelNodeResult readAttributeResult = ops.readAttribute(address, "properties", new ReadAttributeOption[0]);
            if (readAttributeResult.value().isDefined()) {
                for (ModelNode declaredPoperty : readAttributeResult.value().asList()) {
                    String key = declaredPoperty.asProperty().getName();
                    if (this.properties.containsKey(key)) continue;
                    this.properties.put(key, Attribute.of(declaredPoperty.asProperty().getValue().asString()));
                }
            }
            ModelNode propertiesToSet = new ModelNode();
            for (Map.Entry<String, Attribute<String>> property : this.properties.entrySet()) {
                Attribute<String> attrValue = property.getValue();
                if (!attrValue.hasValue() || attrValue.isUndefine()) continue;
                propertiesToSet.get(property.getKey()).set(attrValue.get());
            }
            batch.writeAttribute(address, "properties", propertiesToSet);
        }
        if (orbType == OrbType.IIOP) {
            attributeWriter.write("support-ssl", this.supportSsl.hasValue() ? Attribute.of(this.supportSsl.get().openjdk) : this.supportSsl).write("transactions", this.transactions.hasValue() ? Attribute.of(this.transactions.get().openjdk) : this.transactions).write("security", this.security.hasValue() ? Attribute.of(this.security.get().openjdk) : this.security).write("export-corbaloc", this.exportCorbaloc.hasValue() ? Attribute.of(this.exportCorbaloc.get().openjdk) : this.exportCorbaloc).write("add-component-via-interceptor", this.addComponentViaInterceptor.hasValue() ? Attribute.of(this.addComponentViaInterceptor.get().openjdk) : this.addComponentViaInterceptor).write("giop-version", this.giopVersion).write("persistent-server-id", this.persistentServerId);
        } else {
            attributeWriter.write("support-ssl", this.supportSsl.hasValue() ? Attribute.of(this.supportSsl.get().jacorb) : this.supportSsl).write("transactions", this.transactions.hasValue() ? Attribute.of(this.transactions.get().jacorb) : this.transactions).write("security", this.security.hasValue() ? Attribute.of(this.security.get().jacorb) : this.security).write("export-corbaloc", this.exportCorbaloc.hasValue() ? Attribute.of(this.exportCorbaloc.get().jacorb) : this.exportCorbaloc).write("add-component-via-interceptor", this.addComponentViaInterceptor.hasValue() ? Attribute.of(this.addComponentViaInterceptor.get().jacorb) : this.addComponentViaInterceptor).write("giop-minor-version", this.giopVersion);
        }
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        OrbType orbType = OrbType.get(ctx.version);
        GroovyXmlTransform.Builder transform = GroovyXmlTransform.of(ChangeOrb.class).subtree("iiop", Subtree.subsystem(orbType.subsystemName())).parameter("orbType", (Object)orbType).parameter("subsystem", orbType.subsystemName()).parameter("isOpenjdkIiop", orbType == OrbType.IIOP).parameter("isJacorb", orbType != OrbType.IIOP).parameter("rootContext", this.rootContext).parameter("socketBinding", this.socketBinding).parameter("sslSocketBinding", this.sslSocketBinding).parameter("securityDomain", this.securityDomain).parameter("authMethod", this.authMethodPassword).parameter("realm", this.realm).parameter("required", this.authRequired).parameter("properties", this.properties).parameter("giopVersion", this.giopVersion).parameter("clientRequires", this.clientRequires.hasValue() ? Attribute.of(this.clientRequires.get().value) : this.clientRequires).parameter("serverSupports", this.serverSupports.hasValue() ? Attribute.of(this.serverSupports.get().value) : this.serverSupports).parameter("serverRequires", this.serverRequires.hasValue() ? Attribute.of(this.serverRequires.get().value) : this.serverRequires).parameter("clientSupports", this.clientSupports.hasValue() ? Attribute.of(this.clientSupports.get().value) : this.clientSupports).parameter("integrity", this.integrity.hasValue() ? Attribute.of(this.integrity.get().value) : this.integrity).parameter("confidentiality", this.confidentiality.hasValue() ? Attribute.of(this.confidentiality.get().value) : this.confidentiality).parameter("trustInTarget", this.trustInTarget.hasValue() ? Attribute.of(this.trustInTarget.get().value) : this.trustInTarget).parameter("trustInClient", this.trustInClient.hasValue() ? Attribute.of(this.trustInClient.get().value) : this.trustInClient).parameter("detectReplay", this.detectReplay.hasValue() ? Attribute.of(this.detectReplay.get().value) : this.detectReplay).parameter("detectMisordering", this.detectMisordering.hasValue() ? Attribute.of(this.detectMisordering.get().value) : this.detectMisordering).parameter("callerPropagation", this.callerPropagation.hasValue() ? Attribute.of(this.callerPropagation.get().value) : this.callerPropagation);
        if (orbType == OrbType.IIOP) {
            transform.parameter("supportSsl", this.supportSsl.hasValue() ? Attribute.of(this.supportSsl.get().openjdk) : this.supportSsl).parameter("transactions", this.transactions.hasValue() ? Attribute.of(this.transactions.get().openjdk) : this.transactions).parameter("security", this.security.hasValue() ? Attribute.of(this.security.get().openjdk) : this.security).parameter("exportCorbaloc", this.exportCorbaloc.hasValue() ? Attribute.of(this.exportCorbaloc.get().openjdk) : this.exportCorbaloc).parameter("addComponentViaInterceptor", this.addComponentViaInterceptor.hasValue() ? Attribute.of(this.addComponentViaInterceptor.get().openjdk) : this.addComponentViaInterceptor).parameter("persistentServerId", this.persistentServerId);
        } else {
            transform.parameter("supportSsl", this.supportSsl.hasValue() ? Attribute.of(this.supportSsl.get().jacorb) : this.supportSsl).parameter("transactions", this.transactions.hasValue() ? Attribute.of(this.transactions.get().jacorb) : this.transactions).parameter("security", this.security.hasValue() ? Attribute.of(this.security.get().jacorb) : this.security).parameter("exportCorbaloc", this.exportCorbaloc.hasValue() ? Attribute.of(this.exportCorbaloc.get().jacorb) : this.exportCorbaloc).parameter("addComponentViaInterceptor", this.addComponentViaInterceptor.hasValue() ? Attribute.of(this.addComponentViaInterceptor.get().jacorb) : this.addComponentViaInterceptor).parameter("persistentServerId", Attribute.noValue());
        }
        ctx.client.apply(new OfflineCommand[]{transform.build()});
    }

    public static final class Builder {
        private Attribute<OnOff> supportSsl = Attribute.noValue();
        private Attribute<TransactionValues> transactions = Attribute.noValue();
        private Attribute<String> rootContext = Attribute.noValue();
        private Attribute<String> socketBinding = Attribute.noValue();
        private Attribute<String> sslSocketBinding = Attribute.noValue();
        private Attribute<AuthValues> clientRequires = Attribute.noValue();
        private Attribute<OnOff> addComponentViaInterceptor = Attribute.noValue();
        private Attribute<AuthValues> serverSupports = Attribute.noValue();
        private Attribute<String> giopVersion = Attribute.noValue();
        private Attribute<SecurityValues> security = Attribute.noValue();
        private Attribute<String> securityDomain = Attribute.noValue();
        private Attribute<AuthValues> serverRequires = Attribute.noValue();
        private Attribute<AuthValues> clientSupports = Attribute.noValue();
        private Attribute<OnOff> exportCorbaloc = Attribute.noValue();
        private Attribute<SupportedValues> integrity = Attribute.noValue();
        private Attribute<SupportedValues> confidentiality = Attribute.noValue();
        private Attribute<SupportedValues> trustInTarget = Attribute.noValue();
        private Attribute<SupportedValues> trustInClient = Attribute.noValue();
        private Attribute<SupportedValues> detectReplay = Attribute.noValue();
        private Attribute<SupportedValues> detectMisordering = Attribute.noValue();
        private Attribute<String> authMethodPassword = Attribute.noValue();
        private Attribute<String> realm = Attribute.noValue();
        private Attribute<Boolean> authRequired = Attribute.noValue();
        private Attribute<SupportedValues> callerPropagation = Attribute.noValue();
        private Attribute<String> persistentServerId = Attribute.noValue();
        private Map<String, Attribute<String>> properties = new HashMap<String, Attribute<String>>();

        public Builder transactions(TransactionValues transactions) {
            this.transactions = Attribute.of(transactions);
            return this;
        }

        public Builder supportSsl(Boolean supportSsl) {
            this.supportSsl = Attribute.of(OnOff.get(supportSsl));
            return this;
        }

        public Builder rootContext(String rootContext) {
            this.rootContext = Attribute.of(rootContext);
            return this;
        }

        public Builder socketBinding(String socketBinding) {
            this.socketBinding = Attribute.of(socketBinding);
            return this;
        }

        public Builder sslSocketBinding(String sslSocketBinding) {
            this.sslSocketBinding = Attribute.of(sslSocketBinding);
            return this;
        }

        public Builder clientRequires(AuthValues clientRequires) {
            this.clientRequires = Attribute.of(clientRequires);
            return this;
        }

        public Builder addComponentViaInterceptor(Boolean addComponentViaInterceptor) {
            this.addComponentViaInterceptor = Attribute.of(OnOff.get(addComponentViaInterceptor));
            return this;
        }

        public Builder serverSupports(AuthValues serverSupports) {
            this.serverSupports = Attribute.of(serverSupports);
            return this;
        }

        public Builder giopVersion(String giopVersion) {
            this.giopVersion = Attribute.of(giopVersion);
            return this;
        }

        public Builder security(SecurityValues security) {
            this.security = Attribute.of(security);
            return this;
        }

        public Builder securityDomain(String securityDomain) {
            this.securityDomain = Attribute.of(securityDomain);
            return this;
        }

        public Builder serverRequires(AuthValues serverRequires) {
            this.serverRequires = Attribute.of(serverRequires);
            return this;
        }

        public Builder clientSupports(AuthValues clientSupports) {
            this.clientSupports = Attribute.of(clientSupports);
            return this;
        }

        public Builder exportCorbaloc(Boolean exportCorbaloc) {
            this.exportCorbaloc = Attribute.of(OnOff.get(exportCorbaloc));
            return this;
        }

        public Builder property(String name, String value) {
            this.properties.put(name, Attribute.of(value));
            return this;
        }

        public Builder integrity(SupportedValues integrity) {
            this.integrity = Attribute.of(integrity);
            return this;
        }

        public Builder confidentiality(SupportedValues confidentiality) {
            this.confidentiality = Attribute.of(confidentiality);
            return this;
        }

        public Builder trustInTarget(SupportedValues trustInTarget) {
            this.trustInTarget = Attribute.of(trustInTarget);
            return this;
        }

        public Builder trustInClient(SupportedValues trustInClient) {
            this.trustInClient = Attribute.of(trustInClient);
            return this;
        }

        public Builder detectReplay(SupportedValues detectReplay) {
            this.detectReplay = Attribute.of(detectReplay);
            return this;
        }

        public Builder detectMisordering(SupportedValues detectMisordering) {
            this.detectMisordering = Attribute.of(detectMisordering);
            return this;
        }

        public Builder authMethodPassword(String authMethodPassword) {
            this.authMethodPassword = Attribute.of(authMethodPassword);
            return this;
        }

        public Builder authMethodNone() {
            this.authMethodPassword = Attribute.of("none");
            return this;
        }

        public Builder realm(String realm) {
            this.realm = Attribute.of(realm);
            return this;
        }

        public Builder authRequired(Boolean authRequired) {
            this.authRequired = Attribute.of(authRequired);
            return this;
        }

        public Builder callerPropagation(SupportedValues callerPropagation) {
            this.callerPropagation = Attribute.of(callerPropagation);
            return this;
        }

        public Builder persistentServerId(String persistentServerId) {
            this.persistentServerId = Attribute.of(persistentServerId);
            return this;
        }

        public Builder undefineRootContext() {
            this.rootContext = Attribute.undefine();
            return this;
        }

        public Builder undefineSecurity() {
            this.security = Attribute.undefine();
            return this;
        }

        public Builder undefineSslSocketBinding() {
            this.sslSocketBinding = Attribute.undefine();
            return this;
        }

        public Builder undefineTransactions() {
            this.transactions = Attribute.undefine();
            return this;
        }

        public Builder undefineSupportSsl() {
            this.supportSsl = Attribute.undefine();
            return this;
        }

        public Builder undefineAddComponentViaInterceptor() {
            this.addComponentViaInterceptor = Attribute.undefine();
            return this;
        }

        public Builder undefineSocketBinding() {
            this.socketBinding = Attribute.undefine();
            return this;
        }

        public Builder undefineGiopVersion() {
            this.giopVersion = Attribute.undefine();
            return this;
        }

        public Builder undefineClientRequires() {
            this.clientRequires = Attribute.undefine();
            return this;
        }

        public Builder undefineServerSupports() {
            this.serverSupports = Attribute.undefine();
            return this;
        }

        public Builder undefineSecurityDomain() {
            this.securityDomain = Attribute.undefine();
            return this;
        }

        public Builder undefineServerRequires() {
            this.serverRequires = Attribute.undefine();
            return this;
        }

        public Builder undefineProperty(String name) {
            this.properties.put(name, Attribute.undefineString());
            return this;
        }

        public Builder undefineClientSupports() {
            this.clientSupports = Attribute.undefine();
            return this;
        }

        public Builder undefineExportCorbaloc() {
            this.exportCorbaloc = Attribute.undefine();
            return this;
        }

        public Builder undefineIntegrity() {
            this.integrity = Attribute.undefine();
            return this;
        }

        public Builder undefineConfidentiality() {
            this.confidentiality = Attribute.undefine();
            return this;
        }

        public Builder undefineTrustInTarget() {
            this.trustInTarget = Attribute.undefine();
            return this;
        }

        public Builder undefineTrustInClient() {
            this.trustInClient = Attribute.undefine();
            return this;
        }

        public Builder undefineDetectReplay() {
            this.detectReplay = Attribute.undefine();
            return this;
        }

        public Builder undefineDetectMisordering() {
            this.detectMisordering = Attribute.undefine();
            return this;
        }

        public Builder undefineAuthMethodPassword() {
            this.authMethodPassword = Attribute.undefine();
            return this;
        }

        public Builder undefineAuthMethodNone() {
            this.authMethodPassword = Attribute.undefine();
            return this;
        }

        public Builder undefineRealm() {
            this.realm = Attribute.undefine();
            return this;
        }

        public Builder undefineAuthRequired() {
            this.authRequired = Attribute.undefine();
            return this;
        }

        public Builder undefineCallerPropagation() {
            this.callerPropagation = Attribute.undefine();
            return this;
        }

        public Builder undefinePersistentServerId() {
            this.persistentServerId = Attribute.undefine();
            return this;
        }

        public ChangeOrb build() {
            return new ChangeOrb(this);
        }
    }

    private static final class AttributeWriter {
        private final Address address;
        private final Batch batch;

        AttributeWriter(Address address, Batch batch) {
            this.address = address;
            this.batch = batch;
        }

        AttributeWriter write(String name, Attribute<?> value) {
            if (value == null) {
                return this;
            }
            if (value.isAbsent()) {
                return this;
            }
            if (value.isUndefine()) {
                this.batch.undefineAttribute(this.address, name);
            } else {
                this.batch.writeAttribute(this.address, name, value.get().toString());
            }
            return this;
        }
    }

    static enum OrbType {
        JACORB,
        IIOP;


        static OrbType get(ServerVersion serverVersion) {
            if (serverVersion.lessThan(ServerVersion.VERSION_3_0_0)) {
                return JACORB;
            }
            return IIOP;
        }

        String subsystemName() {
            return this == IIOP ? ChangeOrb.OPENJDK_IIOP_SUBSYSTEM_NAME : ChangeOrb.JACORB_SUBSYSTEM_NAME;
        }
    }
}

