/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.web;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddConnectorSslConfig
implements OnlineCommand,
OfflineCommand {
    private final String connectorName;
    private final String caCertificateFile;
    private final String caCertificatePassword;
    private final String caRevocationUrl;
    private final String certificateFile;
    private final String certificateKeyFile;
    private final String cipherSuite;
    private final String keyAlias;
    private final String keystoreType;
    private final String password;
    private final String protocol;
    private final Integer sessionCacheSize;
    private final Integer sessionTimeout;
    private final String sslProtocol;
    private final String truststoreType;
    private final String verifyClient;
    private final Integer verifyDepth;

    private AddConnectorSslConfig(Builder builder) {
        this.connectorName = builder.connectorName;
        this.caCertificateFile = builder.caCertificateFile;
        this.caCertificatePassword = builder.caCertificatePassword;
        this.caRevocationUrl = builder.caRevocationUrl;
        this.certificateFile = builder.certificateFile;
        this.certificateKeyFile = builder.certificateKeyFile;
        this.cipherSuite = builder.cipherSuite;
        this.keyAlias = builder.keyAlias;
        this.keystoreType = builder.keystoreType;
        this.password = builder.password;
        this.protocol = builder.protocol;
        this.sessionCacheSize = builder.sessionCacheSize;
        this.sessionTimeout = builder.sessionTimeout;
        this.sslProtocol = builder.sslProtocol;
        this.truststoreType = builder.truststoreType;
        this.verifyClient = builder.verifyClient;
        this.verifyDepth = builder.verifyDepth;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Operations ops = new Operations(ctx.client);
        ops.add(Address.subsystem((String)"web").and("connector", this.connectorName).and("configuration", "ssl"), Values.empty().andOptional("ca-certificate-file", this.caCertificateFile).andOptional("ca-certificate-password", this.caCertificatePassword).andOptional("ca-revocation-url", this.caRevocationUrl).andOptional("certificate-file", this.certificateFile).andOptional("certificate-key-file", this.certificateKeyFile).andOptional("cipher-suite", this.cipherSuite).andOptional("key-alias", this.keyAlias).andOptional("keystore-type", this.keystoreType).andOptional("password", this.password).andOptional("protocol", this.protocol).andOptional("session-cache-size", this.sessionCacheSize).andOptional("session-timeout", this.sessionTimeout).andOptional("ssl-protocol", this.sslProtocol).andOptional("truststore-type", this.truststoreType).andOptional("verify-client", this.verifyClient).andOptional("verify-depth", this.verifyDepth));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        GroovyXmlTransform sslConf = GroovyXmlTransform.of(AddConnectorSslConfig.class).subtree("web", Subtree.subsystem("web")).parameter("connectorName", this.connectorName).parameter("caCertificateFile", this.caCertificateFile).parameter("caCertificatePassword", this.caCertificatePassword).parameter("caRevocationUrl", this.caRevocationUrl).parameter("certificateFile", this.certificateFile).parameter("certificateKeyFile", this.certificateKeyFile).parameter("cipherSuite", this.cipherSuite).parameter("keyAlias", this.keyAlias).parameter("keystoreType", this.keystoreType).parameter("password", this.password).parameter("protocol", this.protocol).parameter("sessionCacheSize", this.sessionCacheSize).parameter("sessionTimeout", this.sessionTimeout).parameter("sslProtocol", this.sslProtocol).parameter("truststoreType", this.truststoreType).parameter("verifyClient", this.verifyClient).parameter("verifyDepth", this.verifyDepth).build();
        ctx.client.apply(new OfflineCommand[]{sslConf});
    }

    public String toString() {
        return "AddConnectorSslConfig " + this.connectorName;
    }

    public static final class Builder {
        private final String connectorName;
        private String caCertificateFile;
        private String caCertificatePassword;
        private String caRevocationUrl;
        private String certificateFile;
        private String certificateKeyFile;
        private String cipherSuite;
        private String keyAlias;
        private String keystoreType;
        private String password;
        private String protocol;
        private Integer sessionCacheSize;
        private Integer sessionTimeout;
        private String sslProtocol;
        private String truststoreType;
        private String verifyClient;
        private Integer verifyDepth;

        public Builder(String connectorName) {
            if (connectorName == null) {
                throw new IllegalArgumentException("Name of the connector must be specified as non null value");
            }
            this.connectorName = connectorName;
        }

        public Builder caCertificateFile(String caCertificateFile) {
            this.caCertificateFile = caCertificateFile;
            return this;
        }

        public Builder caCertificatePassword(String caCertificatePassword) {
            this.caCertificatePassword = caCertificatePassword;
            return this;
        }

        public Builder caRevocationUrl(String caRevocationUrl) {
            this.caRevocationUrl = caRevocationUrl;
            return this;
        }

        public Builder certificateFile(String certificateFile) {
            this.certificateFile = certificateFile;
            return this;
        }

        public Builder certificateKeyFile(String certificateKeyFile) {
            this.certificateKeyFile = certificateKeyFile;
            return this;
        }

        public Builder cipherSuite(String cipherSuite) {
            this.cipherSuite = cipherSuite;
            return this;
        }

        public Builder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public Builder keystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder sessionCacheSize(Integer sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return this;
        }

        public Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder sslProtocol(String sslProtocol) {
            this.sslProtocol = sslProtocol;
            return this;
        }

        public Builder truststoreType(String truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder verifyClient(String verifyClient) {
            this.verifyClient = verifyClient;
            return this;
        }

        public Builder verifyDepth(Integer verifyDepth) {
            this.verifyDepth = verifyDepth;
            return this;
        }

        public AddConnectorSslConfig build() {
            return new AddConnectorSslConfig(this);
        }
    }
}

