/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.diff.ProvisionedFeatureDiffCallback;
import org.jboss.galleon.diff.ProvisioningDiffProvider;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.xml.ProvisionedConfigBuilder;
import org.jboss.galleon.xml.ProvisionedConfigXmlParser;
import org.jboss.galleon.xml.ProvisionedConfigXmlWriter;
import org.jboss.galleon.xml.ProvisionedFeatureBuilder;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.wildfly.galleon.plugin.config.generator.WfEmbeddedTaskBase;
import org.wildfly.galleon.plugin.config.generator.WfFeatureDiffCallback;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;

public class WfConfigsReader
extends WfEmbeddedTaskBase<List<ProvisionedConfig>> {
    private static final String DOMAIN_ELEMENT = "<domain ";
    private static final String HOST_ELEMENT = "<host ";
    private static final String SERVER_ELEMENT = "<server ";
    private static final String ADDED = "added";
    private static final String UPDATED = "updated";
    private static final String DOT_XML = ".xml";
    private static final Set<String> READ_ONLY_PATHS;
    private Path home;
    private MessageWriter log;
    private Map<ConfigId, String> configIds;
    private ProvisioningLayout<FeaturePackRuntimeBuilder> layout;
    private ProvisionedState provisionedState;
    private Map<String, FeatureSpec> loadedSpecs = Collections.emptyMap();
    private ConfigId configId;
    private List<ProvisionedConfig> updatedConfigs = Collections.emptyList();
    private List<ProvisionedConfig> addedConfigs = Collections.emptyList();
    private String hostName;

    private static void processPaths(Path home, Iterable<String> relativePaths, FsEntryProvider fsEntries, Map<ConfigId, String> affectedConfigs) throws ProvisioningException {
        for (String relativePath : relativePaths) {
            String model;
            if (!WfConfigsReader.isWfConfig(relativePath)) continue;
            String rootElement = WfConfigsReader.getRootElement(home.resolve(relativePath));
            if (rootElement.regionMatches(0, SERVER_ELEMENT, 0, SERVER_ELEMENT.length())) {
                model = "standalone";
            } else if (rootElement.regionMatches(0, DOMAIN_ELEMENT, 0, DOMAIN_ELEMENT.length())) {
                model = "domain";
            } else {
                if (!rootElement.regionMatches(0, HOST_ELEMENT, 0, HOST_ELEMENT.length())) continue;
                model = "host";
            }
            FsEntry modifiedEntry = fsEntries.getFsEntry(relativePath);
            affectedConfigs.put(new ConfigId(model, modifiedEntry.getName()), modifiedEntry.getRelativePath());
        }
    }

    private static boolean isWfConfig(String relativePath) {
        int i;
        if (!relativePath.endsWith(DOT_XML)) {
            return false;
        }
        if (relativePath.startsWith("standalone")) {
            i = "standalone".length();
        } else if (relativePath.startsWith("domain")) {
            i = "domain".length();
        } else {
            return false;
        }
        if (relativePath.charAt(i) != '/') {
            return false;
        }
        if (!relativePath.regionMatches(++i, "configuration", 0, "configuration".length())) {
            return false;
        }
        if (relativePath.charAt(i += "configuration".length()) != '/') {
            return false;
        }
        return relativePath.indexOf(47, i + 1) <= 0;
    }

    public static void exportDiff(ProvisioningDiffProvider diffProvider) throws ProvisioningException {
        final FsDiff fsDiff = diffProvider.getFsDiff();
        LinkedHashMap<ConfigId, String> affectedConfigs = new LinkedHashMap<ConfigId, String>(0);
        if (fsDiff.hasModifiedEntries()) {
            WfConfigsReader.processPaths(fsDiff.getOtherRoot().getPath(), fsDiff.getModifiedPaths(), new FsEntryProvider(){

                @Override
                public FsEntry getFsEntry(String relativePath) {
                    return fsDiff.getModifiedEntry(relativePath)[0];
                }
            }, affectedConfigs);
        }
        if (fsDiff.hasAddedEntries()) {
            WfConfigsReader.processPaths(fsDiff.getOtherRoot().getPath(), fsDiff.getAddedPaths(), new FsEntryProvider(){

                @Override
                public FsEntry getFsEntry(String relativePath) {
                    return fsDiff.getAddedEntry(relativePath);
                }
            }, affectedConfigs);
        }
        if (!affectedConfigs.isEmpty()) {
            WfConfigsReader reader = new WfConfigsReader();
            reader.log = diffProvider.getMessageWriter();
            reader.home = fsDiff.getOtherRoot().getPath();
            reader.configIds = affectedConfigs;
            reader.generate((ProvisioningLayout<FeaturePackRuntimeBuilder>)diffProvider.getProvisioningLayout(), diffProvider.getProvisionedState(), reader.home, reader.log, false);
            WfFeatureDiffCallback featureCallback = null;
            if (!reader.updatedConfigs.isEmpty()) {
                featureCallback = new WfFeatureDiffCallback();
                for (ProvisionedConfig config : reader.updatedConfigs) {
                    diffProvider.updateConfig((ProvisionedFeatureDiffCallback)featureCallback, config, new String[]{reader.configIds.get(new ConfigId(config.getModel(), config.getName()))});
                }
            }
            if (!reader.addedConfigs.isEmpty()) {
                if (featureCallback == null) {
                    featureCallback = new WfFeatureDiffCallback();
                }
                for (ProvisionedConfig config : reader.addedConfigs) {
                    diffProvider.addConfig((ProvisionedFeatureDiffCallback)featureCallback, config, new String[]{reader.configIds.get(new ConfigId(config.getModel(), config.getName()))});
                }
            }
        }
        if (fsDiff.hasRemovedEntries()) {
            block10: for (String relativePath : fsDiff.getRemovedPaths()) {
                ConfigId configId;
                if (!WfConfigsReader.isWfConfig(relativePath)) continue;
                FsEntry removed = fsDiff.getRemovedEntry(relativePath);
                switch (relativePath.substring(0, relativePath.indexOf(47))) {
                    case "standalone": {
                        configId = new ConfigId("standalone", removed.getName());
                        break;
                    }
                    case "domain": {
                        String model = null;
                        for (ProvisionedConfig provisioned : diffProvider.getProvisionedState().getConfigs()) {
                            if (!provisioned.getName().equals(removed.getName())) continue;
                            if (model != null) {
                                model = null;
                                break;
                            }
                            model = provisioned.getModel();
                        }
                        if (model == null) continue block10;
                        configId = new ConfigId(model, removed.getName());
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                diffProvider.removeConfig(configId, new String[]{relativePath});
            }
        }
    }

    @Override
    protected String getHome(ProvisioningRuntime runtime) {
        return this.home.toString();
    }

    @Override
    protected void doGenerate(ProvisioningLayout<FeaturePackRuntimeBuilder> layout, ProvisionedState provisionedState) throws ProvisioningException {
        this.layout = layout;
        this.provisionedState = provisionedState;
        for (Map.Entry<ConfigId, String> entry : this.configIds.entrySet()) {
            Path configXml = this.home.resolve(entry.getValue());
            if (!Files.exists(configXml, new LinkOption[0])) {
                throw new ProvisioningException("Config " + this.configId + " does not exist: " + configXml);
            }
            this.configId = entry.getKey();
            this.readConfig(this.getConfigArg(this.configId.getModel()), configXml);
        }
    }

    @Override
    protected String[] getForkArgs() throws ProvisioningException {
        String[] superArgs = super.getForkArgs();
        int i = superArgs.length + 2;
        String[] args = new String[i];
        System.arraycopy(superArgs, 0, args, 0, superArgs.length);
        Path workDir = this.layout.getTmpPath(new String[]{"forked-wf-diff"});
        Path configXml = workDir.resolve("provisioning.xml");
        try {
            ProvisioningXmlWriter.getInstance().write((Object)this.layout.getConfig(), configXml);
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to persist provisioning config", (Throwable)e);
        }
        args[--i] = configXml.toString();
        args[--i] = workDir.resolve("configs").toAbsolutePath().toString();
        return args;
    }

    @Override
    public void forkedForEmbedded(String ... args) throws ConfigGeneratorException {
        int i = args.length;
        String provisioningXml = args[--i];
        try {
            ProvisioningConfig provisioningConfig = ProvisioningXmlParser.parse((Path)Paths.get(provisioningXml, new String[0]));
            this.layout = ProvisioningLayoutFactory.getInstance(null).newConfigLayout(provisioningConfig, (FeaturePackLayoutFactory)new FeaturePackLayoutFactory<FeaturePackRuntimeBuilder>(){

                public FeaturePackRuntimeBuilder newFeaturePack(FeaturePackLocation fpl, FeaturePackSpec spec, Path dir, int type) throws ProvisioningException {
                    return new FeaturePackRuntimeBuilder(fpl.getFPID(), null, dir, type);
                }
            }, false);
            super.forkedForEmbedded(args);
            --i;
            if (!this.addedConfigs.isEmpty()) {
                WfConfigsReader.persistConfigs(args[i], ADDED, this.addedConfigs);
            }
            if (!this.updatedConfigs.isEmpty()) {
                WfConfigsReader.persistConfigs(args[i], UPDATED, this.updatedConfigs);
            }
        }
        catch (ProvisioningException e) {
            throw new ConfigGeneratorException((Exception)((Object)e));
        }
    }

    public void forkedEmbeddedDone(String ... args) throws ConfigGeneratorException {
        DirectoryStream<Path> stream;
        Path configsDir = Paths.get(args[args.length - 3], new String[0]);
        if (!Files.exists(configsDir, new LinkOption[0])) {
            return;
        }
        Path p = configsDir.resolve(ADDED);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                stream = Files.newDirectoryStream(p);
                try {
                    for (Path xml : stream) {
                        this.addedConfigs = CollectionUtils.add(this.addedConfigs, (Object)ProvisionedConfigXmlParser.parse((Path)xml));
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException | ProvisioningException e) {
                throw new ConfigGeneratorException(Errors.readDirectory((Path)p), e);
            }
        }
        if (Files.exists(p = configsDir.resolve(UPDATED), new LinkOption[0])) {
            try {
                stream = Files.newDirectoryStream(p);
                try {
                    for (Path xml : stream) {
                        this.updatedConfigs = CollectionUtils.add(this.updatedConfigs, (Object)ProvisionedConfigXmlParser.parse((Path)xml));
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException | ProvisioningException e) {
                throw new ConfigGeneratorException(Errors.readDirectory((Path)p), e);
            }
        }
    }

    private static void persistConfigs(String baseDir, String type, List<ProvisionedConfig> configs) throws ProvisioningException {
        Path configsDir = Paths.get(baseDir, new String[0]).resolve(type);
        try {
            Files.createDirectories(configsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.mkdirs((Path)configsDir), (Throwable)e);
        }
        ProvisionedConfigXmlWriter writer = ProvisionedConfigXmlWriter.getInstance();
        for (ProvisionedConfig config : configs) {
            try {
                writer.write((Object)config, configsDir.resolve(config.getName()));
            }
            catch (Exception e) {
                throw new ProvisioningException(Errors.writeFile((Path)configsDir.resolve(config.getName())), (Throwable)e);
            }
        }
    }

    private String getConfigArg(String configModel) {
        switch (configModel) {
            case "standalone": {
                return "--server-config";
            }
            case "domain": {
                return "--domain-config";
            }
            case "host": {
                return "--host-config";
            }
        }
        throw new IllegalStateException("Unexpected config model " + configModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig(String configArg, Path configPath) throws ProvisioningException {
        try {
            ModelNode readConfigOp = Operations.createOperation((String)"read-config-as-features");
            if (configArg.equals("--server-config")) {
                this.startServer("--admin-only", configArg, configPath.getFileName().toString());
            } else {
                this.startHc(configArg, configPath.getFileName().toString());
                if (configArg.equals("--host-config")) {
                    this.hostName = "";
                    ModelNode readHostNameOp = Operations.createOperation((String)"read-children-names");
                    readHostNameOp.get("child-type").set("host");
                    this.handle(readHostNameOp);
                    ModelNode addr = readConfigOp.get("address");
                    addr.add("host", this.hostName);
                    this.hostName = null;
                }
            }
            readConfigOp.get("nested").set(false);
            this.handle(readConfigOp);
        }
        finally {
            this.stopEmbedded();
        }
    }

    @Override
    protected void handleSuccess(ModelNode response) throws ProvisioningException {
        int model;
        if (this.hostName != null) {
            if (!Operations.isSuccessfulOutcome((ModelNode)response)) {
                throw new ProvisioningException("Failed to determine the host name: " + Operations.getFailureDescription((ModelNode)response));
            }
            List list = Operations.readResult((ModelNode)response).asList();
            if (list.size() != 1) {
                throw new ProvisioningException("Failed to determine the host name: expected one item in the list but got " + list);
            }
            this.hostName = ((ModelNode)list.get(0)).asString();
            return;
        }
        switch (this.configId.getModel()) {
            case "standalone": {
                model = 0;
                break;
            }
            case "domain": {
                model = 1;
                break;
            }
            case "host": {
                model = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected config model " + this.configId.getModel());
            }
        }
        if (this.log != null) {
            this.log.verbose("Reading config %s", new Object[]{this.configId});
        }
        ProvisionedConfigBuilder configBuilder = null;
        String prevSpec = null;
        ResolvedSpecId specId = null;
        for (ModelNode featureNode : response.get("result").asList()) {
            List props;
            String specName;
            try {
                specName = featureNode.get("spec").asString();
            }
            catch (Throwable t) {
                throw new ProvisioningException("Failed to process " + featureNode, t);
            }
            if (model == 1 && specName.startsWith("profile.")) {
                specName = specName.substring("profile.".length());
            }
            if (!specName.equals(prevSpec)) {
                specId = this.resolveSpec(specName);
                if (specId == null) {
                    if (model == 1 && specName.startsWith("domain.")) {
                        specId = this.resolveSpec(specName.substring("domain.".length()));
                        if (specId == null) {
                            throw new ProvisioningException("Failed to locate feature spec " + featureNode.get("spec").asString() + " in the installed feature-packs");
                        }
                    } else if (model == 2 && specName.startsWith("host.")) {
                        specId = this.resolveSpec(specName.substring("host.".length()));
                        if (specId == null) {
                            throw new ProvisioningException("Failed to locate feature spec " + featureNode.get("spec").asString() + " in the installed feature-packs");
                        }
                    } else {
                        throw new ProvisioningException("Failed to locate feature spec " + featureNode.get("spec").asString() + " in the installed feature-packs");
                    }
                }
                prevSpec = specName;
            }
            ResolvedFeatureId actualFeatureId = null;
            if (featureNode.hasDefined("id") && !(props = featureNode.get("id").asPropertyList()).isEmpty()) {
                ResolvedFeatureId.Builder idBuilder = ResolvedFeatureId.builder((ResolvedSpecId)specId);
                for (Property prop : props) {
                    idBuilder.setParam(prop.getName(), (Object)prop.getValue().asString());
                }
                actualFeatureId = idBuilder.build();
            }
            if (specName.equals("path") && READ_ONLY_PATHS.contains(actualFeatureId.getParams().get("path"))) continue;
            List params = featureNode.hasDefined("params") ? featureNode.get("params").asPropertyList() : Collections.emptyList();
            ProvisionedFeatureBuilder featureBuilder = actualFeatureId == null ? ProvisionedFeatureBuilder.builder((ResolvedSpecId)specId) : ProvisionedFeatureBuilder.builder(actualFeatureId);
            FeatureSpec featureSpec = this.getFeatureSpec(specId);
            for (Property param : params) {
                String paramName = param.getName();
                if (!featureSpec.hasParam(paramName)) {
                    if (this.log == null) continue;
                    this.log.print((CharSequence)("WARN: parameter " + paramName + " is not found in " + specId));
                    continue;
                }
                if (paramName.equals("module") && specName.equals("extension") && param.getValue().equals(actualFeatureId.getParams().get("extension"))) continue;
                featureBuilder.setConfigParam(param.getName(), param.getValue().asString());
            }
            if (configBuilder == null) {
                configBuilder = ProvisionedConfigBuilder.builder().setModel(this.configId.getModel()).setName(this.configId.getName());
            }
            configBuilder.addFeature(featureBuilder.build());
        }
        if (configBuilder != null) {
            boolean existing = false;
            for (ProvisionedConfig config : this.provisionedState.getConfigs()) {
                if (config.getModel() != null && !config.getModel().equals(this.configId.getModel()) || config.getName() != null && !config.getName().equals(this.configId.getName())) continue;
                existing = true;
                break;
            }
            if (existing) {
                this.updatedConfigs = CollectionUtils.add(this.updatedConfigs, (Object)configBuilder.build());
            } else {
                this.addedConfigs = CollectionUtils.add(this.addedConfigs, (Object)configBuilder.build());
            }
        }
    }

    private ResolvedSpecId resolveSpec(String specName) throws ProvisioningException {
        List fps = this.layout.getOrderedFeaturePacks();
        for (int i = fps.size() - 1; i >= 0; --i) {
            FeaturePackRuntimeBuilder fp = (FeaturePackRuntimeBuilder)fps.get(i);
            ResolvedFeatureSpec spec = fp.getFeatureSpec(specName);
            if (spec == null) continue;
            return spec.getId();
        }
        return null;
    }

    private FeatureSpec getFeatureSpec(ResolvedSpecId specId) throws ProvisioningException {
        FeatureSpec featureSpec = this.loadedSpecs.get(specId.getName());
        if (featureSpec != null) {
            return featureSpec;
        }
        featureSpec = ((FeaturePackRuntimeBuilder)this.layout.getFeaturePack(specId.getProducer())).getFeatureSpec(specId.getName()).getSpec();
        this.loadedSpecs = CollectionUtils.put(this.loadedSpecs, (Object)specId.getName(), (Object)featureSpec);
        return featureSpec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getRootElement(Path configPath) throws ProvisioningException {
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            String line = reader.readLine();
            if (line == null) {
                String string = null;
                return string;
            }
            do {
                if ((line = line.trim()).isEmpty() || line.charAt(0) != '<') continue;
                if (line.length() < 2) {
                    String string = null;
                    return string;
                }
                char c = line.charAt(1);
                if (c == '?' || c == '!') continue;
                String string = line;
                return string;
            } while ((line = reader.readLine()) != null);
            return null;
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)configPath), (Throwable)e);
        }
    }

    @Override
    public void forkedEmbeddedMessage(String msg) {
    }

    @Override
    public List<ProvisionedConfig> getResult() {
        return Collections.emptyList();
    }

    @Override
    protected void doStartServer(String ... args) throws ProvisioningException {
        if (this.configId == null) {
            this.configId = new ConfigId("standalone", WfConfigsReader.getArg("--server-config", "standalone.xml", args));
        }
        super.doStartServer(args);
    }

    @Override
    protected void doStartHc(String ... args) throws ProvisioningException {
        if (this.configId == null) {
            int i = 0;
            while (i < args.length) {
                String argValue;
                if ((argValue = args[i++]).equals("--host-config")) {
                    this.configId = new ConfigId("host", args[i]);
                    break;
                }
                if (!argValue.equals("--domain-config")) continue;
                this.configId = new ConfigId("domain", args[i]);
            }
        }
        super.doStartHc(args);
    }

    @Override
    void stopEmbedded() throws ProvisioningException {
        super.stopEmbedded();
        this.configId = null;
    }

    private static String getArg(String argName, String defValue, String ... args) {
        int i = 0;
        while (i < args.length) {
            if (!argName.equals(args[i++])) continue;
            return args[i];
        }
        return defValue;
    }

    static {
        HashSet<String> tmp = new HashSet<String>(10);
        tmp.add("java.home");
        tmp.add("jboss.home.dir");
        tmp.add("jboss.controller.temp.dir");
        tmp.add("jboss.server.temp.dir");
        tmp.add("user.home");
        tmp.add("user.dir");
        tmp.add("jboss.server.config.dir");
        tmp.add("jboss.server.base.dir");
        tmp.add("jboss.server.data.dir");
        tmp.add("jboss.server.log.dir");
        READ_ONLY_PATHS = Collections.unmodifiableSet(tmp);
    }

    private static interface FsEntryProvider {
        public FsEntry getFsEntry(String var1);
    }

    public static class ConfigSpecMapper
    implements ProvisionedConfigHandler {
        Map<String, Map<ResolvedFeatureId, ProvisionedFeature>> features = new HashMap<String, Map<ResolvedFeatureId, ProvisionedFeature>>();
        Map<String, ResolvedSpecId> specs = new HashMap<String, ResolvedSpecId>();
        Set<String> excludedSpecs = Collections.emptySet();
        private String specName;
        private Map<ResolvedFeatureId, ProvisionedFeature> specFeatures;

        public void reset() {
            this.features.clear();
            this.specs.clear();
            this.excludedSpecs = Collections.emptySet();
            this.specName = null;
            this.specFeatures = null;
        }

        public void map(ProvisionedConfig config) throws ProvisioningException {
            config.handle((ProvisionedConfigHandler)this);
            this.specName = null;
            this.specFeatures = null;
        }

        public void nextSpec(ResolvedFeatureSpec spec) throws ProvisioningException {
            this.specName = spec.getName();
            this.specFeatures = this.features.get(this.specName);
            if (this.specFeatures == null) {
                this.specFeatures = new LinkedHashMap<ResolvedFeatureId, ProvisionedFeature>();
                this.features.put(this.specName, this.specFeatures);
            }
            this.specs.put(this.specName, spec.getId());
        }

        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            if (feature.getId() == null) {
                this.excludedSpecs = CollectionUtils.addLinked(this.excludedSpecs, (Object)feature.getSpecId().getName());
                return;
            }
            this.specFeatures.put(feature.getId(), feature);
        }
    }
}

