/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.PropertyUtils;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.config.FilePermission;

public class FilePermissions
implements WildFlyPackageTask {
    private WildFlyPackageTask.Phase phase = WildFlyPackageTask.Phase.PROCESSING;
    private List<FilePermission> permissions = Collections.emptyList();

    public void setPhase(String phase) {
        this.phase = WildFlyPackageTask.Phase.valueOf(phase);
    }

    public void addFilePermissions(FilePermission filePermission) {
        this.permissions = CollectionUtils.add(this.permissions, (Object)filePermission);
    }

    @Override
    public WildFlyPackageTask.Phase getPhase() {
        return this.phase;
    }

    @Override
    public void execute(WfInstallPlugin plugin, PackageRuntime pkg) throws ProvisioningException {
        if (PropertyUtils.isWindows()) {
            return;
        }
        try {
            final Path installDir = plugin.getRuntime().getStagedDir();
            Files.walkFileTree(installDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relative = installDir.relativize(dir).toString();
                    for (FilePermission perm : FilePermissions.this.permissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(dir, perm.getPermission());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relative = installDir.relativize(file).toString();
                    for (FilePermission perm : FilePermissions.this.permissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(file, perm.getPermission());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to set file permissions", (Throwable)e);
        }
    }
}

