/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.galleon.plugin.AbstractArtifactInstaller;
import org.wildfly.galleon.plugin.ArtifactRecorder;
import org.wildfly.galleon.plugin.WfInstallPlugin;

class SimpleArtifactInstaller
extends AbstractArtifactInstaller {
    private final Optional<ArtifactRecorder> artifactRecorder;

    SimpleArtifactInstaller(WfInstallPlugin.ArtifactResolver resolver, Path generatedMavenRepo, Optional<ArtifactRecorder> artifactRecorder) {
        super(resolver, generatedMavenRepo);
        this.artifactRecorder = artifactRecorder;
    }

    @Override
    String installArtifactFat(MavenArtifact artifact, Path targetDir) throws IOException, MavenUniverseException, ProvisioningException {
        if (this.artifactRecorder.isPresent()) {
            this.artifactRecorder.get().record(artifact, targetDir.resolve(artifact.getArtifactFileName()));
        }
        Files.copy(artifact.getPath(), targetDir.resolve(artifact.getArtifactFileName()), StandardCopyOption.REPLACE_EXISTING);
        return artifact.getArtifactFileName();
    }

    @Override
    String installArtifactThin(MavenArtifact artifact) throws IOException, MavenUniverseException, ProvisioningException {
        this.installInGeneratedRepo(artifact, artifact.getVersion(), artifact.getPath());
        return artifact.getVersion();
    }

    @Override
    Path installCopiedArtifact(MavenArtifact artifact) throws IOException, ProvisioningException {
        this.installInGeneratedRepo(artifact, artifact.getVersion(), artifact.getPath());
        return artifact.getPath();
    }
}

