/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.ConfigurationResolver;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.Layer;
import org.wildfly.glow.OutputContent;
import org.wildfly.glow.ScanResultsPrinter;
import org.wildfly.glow.Suggestions;
import org.wildfly.glow.error.ErrorIdentificationSession;

public class ScanResults
implements AutoCloseable {
    private final GlowSession glowSession;
    private final Set<Layer> discoveredLayers;
    private final Set<Layer> excludedLayers;
    private final Layer baseLayer;
    private final Set<Layer> decorators;
    private final Set<Layer> metadataOnlyLayers;
    private final Provisioning provisioning;
    private final GalleonProvisioningConfig config;
    private final ErrorIdentificationSession errorSession;
    private final Map<AddOn, String> disabledAddOns;
    private final Set<AddOn> enabledAddOns;
    private final Suggestions suggestions;
    private final Set<String> excludedPackages;
    private final Map<Layer, Set<String>> excludedFeatures;
    private final Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> fpVersions;

    ScanResults(GlowSession glowSession, Set<Layer> discoveredLayers, Set<Layer> excludedLayers, Layer baseLayer, Set<Layer> decorators, Set<Layer> metadataOnlyLayers, Provisioning provisioning, GalleonProvisioningConfig config, Set<AddOn> enabledAddOns, Map<AddOn, String> disabledAddOns, Suggestions suggestions, ErrorIdentificationSession errorSession, Set<String> excludedPackages, Map<Layer, Set<String>> excludedFeatures, Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> fpVersions) {
        this.glowSession = glowSession;
        this.discoveredLayers = discoveredLayers;
        this.excludedLayers = excludedLayers;
        this.baseLayer = baseLayer;
        this.decorators = decorators;
        this.metadataOnlyLayers = metadataOnlyLayers;
        this.provisioning = provisioning;
        this.config = config;
        this.disabledAddOns = disabledAddOns;
        this.enabledAddOns = enabledAddOns;
        this.suggestions = suggestions;
        this.errorSession = errorSession;
        this.excludedPackages = excludedPackages;
        this.excludedFeatures = excludedFeatures;
        this.fpVersions = fpVersions;
    }

    public Set<Layer> getDiscoveredLayers() {
        return this.discoveredLayers;
    }

    public Set<Layer> getExcludedLayers() {
        return this.excludedLayers;
    }

    public Layer getBaseLayer() {
        return this.baseLayer;
    }

    public Set<Layer> getDecorators() {
        return this.decorators;
    }

    public Set<Layer> getMetadataOnlyLayers() {
        return this.metadataOnlyLayers;
    }

    public Provisioning getProvisioning() {
        return this.provisioning;
    }

    public GalleonProvisioningConfig getProvisioningConfig() {
        return this.config;
    }

    public Suggestions getSuggestions() {
        return this.suggestions;
    }

    public ErrorIdentificationSession getErrorSession() {
        return this.errorSession;
    }

    public Map<AddOn, String> getDisabledAddOns() {
        return this.disabledAddOns;
    }

    public Set<AddOn> getEnabledAddOns() {
        return this.enabledAddOns;
    }

    public OutputContent outputConfig(Path target, String dockerImageName) throws Exception {
        return this.glowSession.outputConfig(this, target, dockerImageName);
    }

    public void outputInformation() throws Exception {
        this.outputInformation(GlowMessageWriter.DEFAULT, null);
    }

    public void outputCompactInformation() throws Exception {
        this.outputCompactInformation(GlowMessageWriter.DEFAULT);
    }

    public void outputInformation(ConfigurationResolver resolver) throws Exception {
        this.outputInformation(GlowMessageWriter.DEFAULT, resolver);
    }

    public void outputInformation(GlowMessageWriter writer) throws Exception {
        this.outputInformation(writer, null);
    }

    public void outputInformation(GlowMessageWriter writer, ConfigurationResolver resolver) throws Exception {
        ScanResultsPrinter printer = new ScanResultsPrinter(writer, resolver);
        this.glowSession.outputInformation(printer, this);
    }

    public void outputCompactInformation(GlowMessageWriter writer) throws Exception {
        ScanResultsPrinter printer = new ScanResultsPrinter(writer);
        this.glowSession.outputCompactInformation(printer, this);
    }

    public String getCompactInformation() throws Exception {
        ScanResultsPrinter printer = new ScanResultsPrinter(GlowMessageWriter.DEFAULT);
        return this.glowSession.getCompactInformation(printer, this);
    }

    @Override
    public void close() {
        this.provisioning.close();
    }

    public Set<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public Map<Layer, Set<String>> getExcludedFeatures() {
        return this.excludedFeatures;
    }

    public Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> getFeaturePackVersions() {
        return this.fpVersions;
    }
}

