/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.ChannelResolvable;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.plugins.bootablejar.maven.goals.ChannelConfiguration;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ManifestVersionResolver;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;

public class ChannelMavenArtifactRepositoryManager
implements MavenRepoManager,
ChannelResolvable {
    private static final String REQUIRE_CHANNEL_FOR_ALL_ARTIFACT = "org.wildfly.plugins.galleon.all.artifact.requires.channel.resolution";
    private final ChannelSession channelSession;
    private final List<Channel> channels = new ArrayList<Channel>();
    private final Log log;
    private final Path localCachePath;
    private final RepositorySystem system;

    public ChannelMavenArtifactRepositoryManager(List<ChannelConfiguration> channels, RepositorySystem system, RepositorySystemSession contextSession, List<RemoteRepository> repositories, Log log, boolean offline) throws MalformedURLException, UnresolvedMavenArtifactException, MojoExecutionException {
        if (channels.isEmpty()) {
            throw new MojoExecutionException("No channel specified.");
        }
        this.log = log;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(contextSession.getLocalRepositoryManager());
        session.setOffline(offline);
        HashMap<String, RemoteRepository> mapping = new HashMap<String, RemoteRepository>();
        for (RemoteRepository r2 : repositories) {
            mapping.put(r2.getId(), r2);
        }
        for (ChannelConfiguration channelConfiguration : channels) {
            this.channels.add(channelConfiguration.toChannel(repositories));
        }
        Function<Repository, RemoteRepository> mapper = r -> {
            RemoteRepository rep = (RemoteRepository)mapping.get(r.getId());
            if (rep == null) {
                rep = (RemoteRepository)VersionResolverFactory.DEFAULT_REPOSITORY_MAPPER.apply(r);
            }
            return rep;
        };
        VersionResolverFactory factory = new VersionResolverFactory(system, (RepositorySystemSession)session, mapper);
        this.channelSession = new ChannelSession(this.channels, (MavenVersionsResolver.Factory)factory);
        this.localCachePath = contextSession.getLocalRepositoryManager().getRepository().getBasedir().toPath();
        this.system = system;
    }

    public void resolve(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        try {
            this.resolveFromChannels(artifact);
        }
        catch (ArtifactTransferException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (NoStreamFoundException ex) {
            boolean requireChannel = Boolean.parseBoolean((String)artifact.getMetadata().get(REQUIRE_CHANNEL_FOR_ALL_ARTIFACT));
            if (!requireChannel) {
                try {
                    requireChannel = this.fpRequireChannel(artifact);
                }
                catch (Exception exception) {
                    this.log.error((CharSequence)"Error attempting to read artifact as a feature-pack", (Throwable)exception);
                    ex.addSuppressed((Throwable)exception);
                    throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            if (!requireChannel) {
                this.log.warn((CharSequence)("Resolution of artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " failed using configured channels. Using original version."));
                if (artifact.getVersion() == null) {
                    this.log.error((CharSequence)"No version provided.");
                    throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
                }
                try {
                    this.log.warn((CharSequence)("Using version " + artifact.getVersion() + " to resolve artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId()));
                    MavenArtifact mavenArtifact = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
                    artifact.setPath(mavenArtifact.getFile().toPath());
                }
                catch (UnresolvedMavenArtifactException e) {
                    throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private boolean fpRequireChannel(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws Exception {
        boolean requireChannel;
        block16: {
            requireChannel = false;
            if (artifact.getVersion() != null && artifact.getExtension() != null && artifact.getExtension().equalsIgnoreCase("zip")) {
                MavenArtifact mavenArtifact = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
                try {
                    FeaturePackDescriber.readSpec((Path)mavenArtifact.getFile().toPath());
                }
                catch (ProvisioningException ex) {
                    return requireChannel;
                }
                try (FileSystem fs = ZipUtils.newFileSystem((Path)mavenArtifact.getFile().toPath());){
                    Path resPath = fs.getPath("resources", new String[0]);
                    Path wfRes = resPath.resolve("wildfly");
                    Path channelPropsPath = wfRes.resolve("wildfly-channel.properties");
                    if (!Files.exists(channelPropsPath, new LinkOption[0])) break block16;
                    Properties props = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(channelPropsPath);){
                        props.load(reader);
                    }
                    String resolution = props.getProperty("resolution");
                    if (resolution != null) {
                        requireChannel = "REQUIRED".equals(resolution) || "REQUIRED_FP_ONLY".equals(resolution);
                    }
                }
            }
        }
        return requireChannel;
    }

    private void resolveFromChannels(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws UnresolvedMavenArtifactException {
        MavenArtifact result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
        artifact.setVersion(result.getVersion());
        artifact.setPath(result.getFile().toPath());
    }

    public void done(Path home) throws MavenUniverseException, IOException {
        ChannelManifest channelManifest = this.channelSession.getRecordedChannel();
        ManifestVersionRecord currentVersions = new ManifestVersionResolver(this.localCachePath, this.system).getCurrentVersions(this.channels);
        ProsperoMetadataUtils.generate((Path)home, this.channels, (ChannelManifest)channelManifest, (ManifestVersionRecord)currentVersions);
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public boolean isResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public boolean isLatestVersionResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, boolean locallyAvailable) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }

    public void install(org.jboss.galleon.universe.maven.MavenArtifact artifact, Path path) throws MavenUniverseException {
        throw new MavenUniverseException("Channel resolution can't be applied to Galleon universe");
    }
}

