/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractDevBootableJarMojo;

@Mojo(name="dev", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public final class DevBootableJarMojo
extends AbstractDevBootableJarMojo {
    private static final String DEPLOYMENT_SCANNER_LAYER = "deployment-scanner";
    public static final String DEPLOYMENT_SCANNER_NAME = "wildfly-jar-for-dev-mode";
    @Parameter(defaultValue="${project.build.directory}/wildfly-jar-dev-stdout.log", property="wildfly.bootable.stdout")
    public String stdout;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean inherit = "inherit".equalsIgnoreCase(this.stdout);
            Launcher launcher = Launcher.of((CommandBuilder)this.buildCommandBuilder(!inherit));
            if (inherit) {
                launcher.inherit();
            } else {
                Path redirect = Paths.get(this.stdout, new String[0]);
                this.getLog().info((CharSequence)String.format("The stdout and stderr for the process are being logged to %s", redirect));
                launcher.setRedirectErrorStream(true).redirectOutput(redirect);
            }
            launcher.launch();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected void configureServer() {
        if (Files.exists(this.getProvisioningFile(), new LinkOption[0]) && !this.hasLayers()) {
            this.getLog().warn((CharSequence)"Dev mode, can't enforce provisioning of deployment-scanner. Make sure your provisioned configuration contains deployment-scanner subsystem for dev mode to properly operate.");
        } else {
            if (this.getExcludedLayers().contains(DEPLOYMENT_SCANNER_LAYER)) {
                this.getLog().warn((CharSequence)"Dev mode, removing layer deployment-scanner from the list of excluded layers to ensure dev mode can be operated");
                this.getExcludedLayers().remove(DEPLOYMENT_SCANNER_LAYER);
            }
            this.getLog().info((CharSequence)"Dev mode, adding layer deployment-scanner to ensure dev mode can be operated");
            this.addExtraLayer(DEPLOYMENT_SCANNER_LAYER);
        }
    }

    @Override
    protected void configureCli(List<String> commands) {
        super.configureCli(commands);
        this.configureScanner(this.getDeploymentsDir(), commands);
    }

    private void configureScanner(Path deployments, List<String> commands) {
        String deploymentPath = deployments.toString().replace("\\", "\\\\");
        commands.add("if (outcome == success) of /subsystem=deployment-scanner/scanner=default:read-resource()");
        commands.add("/subsystem=deployment-scanner/scanner=default:remove()");
        commands.add("end-if");
        commands.add("/subsystem=deployment-scanner/scanner=wildfly-jar-for-dev-mode:add(scan-interval=1000,auto-deploy-exploded=false,path=\"" + deploymentPath + "\")");
    }
}

