/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.tools.ReusableInputStream;

abstract class DeploymentContent
implements AutoCloseable {
    DeploymentContent() {
    }

    abstract void addContentToOperation(OperationBuilder var1, ModelNode var2);

    String resolvedName() {
        return null;
    }

    @Override
    public void close() {
    }

    static DeploymentContent of(final Path content) {
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                if (Files.isDirectory(content, new LinkOption[0])) {
                    contentItem.get("path").set(content.toAbsolutePath().toString());
                    contentItem.get("archive").set(false);
                } else {
                    contentItem.get("input-stream-index").set(builder.getInputStreamCount());
                    builder.addFileAsAttachment(content.toFile());
                }
            }

            @Override
            String resolvedName() {
                return content.getFileName().toString();
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), content);
            }
        };
    }

    static DeploymentContent of(InputStream content, String name) {
        final ReusableInputStream copiedContent = new ReusableInputStream(content, name);
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                copiedContent.reset();
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                contentItem.get("input-stream-index").set(builder.getInputStreamCount());
                builder.addInputStream((InputStream)copiedContent);
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), copiedContent);
            }

            @Override
            public void close() {
                copiedContent.close(true);
            }
        };
    }

    static DeploymentContent of(final URL url) {
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                contentItem.get("url").set(url.toExternalForm());
            }

            @Override
            String resolvedName() {
                String path = url.getPath();
                int index = path.lastIndexOf(47);
                if (index >= 0) {
                    return path.substring(index + 1);
                }
                return path;
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), url.toExternalForm());
            }
        };
    }

    static DeploymentContent local(final Path content) {
        if (Files.notExists(content, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("File or directory %s does not exist.", content));
        }
        return new DeploymentContent(){

            @Override
            void addContentToOperation(OperationBuilder builder, ModelNode op) {
                ModelNode contentNode = op.get("content");
                ModelNode contentItem = contentNode.get(0);
                contentItem.get("path").set(content.toAbsolutePath().toString());
                contentItem.get("archive").set(!Files.isDirectory(content, new LinkOption[0]));
            }

            @Override
            String resolvedName() {
                return content.getFileName().toString();
            }

            public String toString() {
                return String.format("%s(%s)", DeploymentContent.class.getName(), content);
            }
        };
    }
}

