package org.wildfly.security.pem;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.asn1.ASN1Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.cert.CertificateException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-05-17T17:48:19+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String malformedPemContent$str() {
        return "ELY03010: Malformed PEM content at offset %d";
    }
    @Override
    public final IllegalArgumentException malformedPemContent(final long offset) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), malformedPemContent$str(), offset));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidPemType$str() {
        return "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidPemType(final String expected, final String actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPemType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certificateParseError$str() {
        return "ELY03012: Certificate parse error";
    }
    @Override
    public final IllegalArgumentException certificateParseError(final CertificateException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateParseError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String publicKeyParseError$str() {
        return "ELY03023: PublicKey parse error";
    }
    @Override
    public final IllegalArgumentException publicKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), publicKeyParseError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String privateKeyParseError$str() {
        return "ELY03033: PrivateKey parse error";
    }
    @Override
    public final IllegalArgumentException privateKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), privateKeyParseError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnUnrecognisedAlgorithm$str() {
        return "ELY07001: Unrecognized encoding algorithm [%s]";
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnrecognisedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnUnexpectedTag$str() {
        return "ELY07004: Unexpected ASN.1 tag encountered";
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
