/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools.exec;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;

public class IOBridge
implements Runnable,
Closeable {
    private final InputStream in;
    private final PrintStream out;
    private final CountDownLatch latch;
    private BufferedWriter fileOut;
    private Exception error;

    public IOBridge(CountDownLatch latch, InputStream in, OutputStream out, Path file) throws IOException {
        this.in = in;
        PrintStream printStream = this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        if (file != null) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            this.fileOut = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        this.latch = latch;
    }

    public Exception getError() {
        return this.error;
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        catch (IOException e) {
            this.error = e;
            this.latch.countDown();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (this.fileOut != null) {
                this.fileOut.close();
            }
        }
    }

    protected void processLine(String line) throws IOException {
        this.out.println(line);
        this.out.flush();
        if (this.fileOut != null) {
            this.fileOut.write(line);
            this.fileOut.newLine();
            this.fileOut.flush();
        }
        if (line.contains("WFSWARM99999")) {
            this.latch.countDown();
        }
        if (line.contains("MSC000001: Failed to start service jboss.deployment.unit.")) {
            this.latch.countDown();
        }
    }
}

