/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin.manipulation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.http.util.Asserts;
import org.apache.maven.model.Model;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.ext.common.model.Project;

public class PomManipulator {
    private static final String DEPENDENCY_MANAGEMENT_PATH = "/project/dependencyManagement/dependencies";
    private static final String REPOSITORIES_PATH = "/project/repositories";
    private static final String DEPENDENCIES = "dependencies";
    private static final String REPOSITORIES = "repositories";
    private final Project project;
    private final ModifiedPomXMLEventReader eventReader;
    private final StringBuilder content;
    private boolean closed = false;

    public PomManipulator(Project project) {
        try {
            this.project = project;
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            this.content = PomHelper.readXmlFile((File)project.getPom());
            this.eventReader = new ModifiedPomXMLEventReader(this.content, inputFactory, project.getPom().getPath());
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Couldn't initialize PomWriter instance", e);
        }
    }

    public void overrideDependencyVersion(ArtifactRef d, String newVersion) throws XMLStreamException {
        PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)this.eventReader, (String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getVersionString(), (String)newVersion, (Model)this.project.getModel());
    }

    public void overrideDependencyVersion(String groupId, String artifactId, String oldVersionString, String newVersion) throws XMLStreamException {
        PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)this.eventReader, (String)groupId, (String)artifactId, (String)oldVersionString, (String)newVersion, (Model)this.project.getModel());
    }

    public boolean overrideProperty(String propertyName, String propertyValue) throws XMLStreamException {
        return PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)this.eventReader, null, (String)propertyName, (String)propertyValue);
    }

    public void injectManagedDependency(ArtifactRef dependency, Collection<ProjectRef> exclusions) throws XMLStreamException {
        PomManipulator.injectManagedDependency(this.eventReader, dependency, exclusions);
    }

    public void injectRepository(String id, String url) throws XMLStreamException {
        this.eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            String elementName = event.asEndElement().getName().getLocalPart();
            if (elementName.equals(REPOSITORIES) && ((String)path).equals(REPOSITORIES_PATH)) {
                this.eventReader.mark(0);
                this.eventReader.replaceMark(0, PomManipulator.composeRepositoryElementString(id, url) + "    </repositories>");
                this.eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }

    public void injectProperty(String key, String version) throws XMLStreamException {
        PomManipulator.injectProperty(this.eventReader, key, version);
    }

    public void writePom() {
        this.assertOpen();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)this.project.getPom());){
            this.closed = true;
            IOUtil.copy((String)this.content.toString(), (Writer)writer);
            this.eventReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to the pom file", e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't close event reader", e);
        }
    }

    private void assertOpen() {
        Asserts.check((!this.closed ? 1 : 0) != 0, (String)"This instance cannot be used repeatedly.");
    }

    static void injectManagedDependency(ModifiedPomXMLEventReader eventReader, ArtifactRef dependency, Collection<ProjectRef> exclusions) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals(DEPENDENCIES) && ((String)path).equals(DEPENDENCY_MANAGEMENT_PATH)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composeDependencyElementString(dependency, exclusions) + "        </dependencies>");
                eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }

    static void injectProperty(ModifiedPomXMLEventReader eventReader, String key, String version) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals("properties") && ((String)path).equals("/project/properties")) {
                eventReader.mark(0);
                eventReader.replaceMark(0, String.format("    <%s>%s</%s>\n", key, version, key) + "    </properties>");
                eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }

    private static String composeDependencyElementString(ArtifactRef artifact, Collection<ProjectRef> exclusions) {
        StringBuilder sb = new StringBuilder();
        sb.append("    <dependency>\n");
        sb.append(String.format("                <groupId>%s</groupId>\n", artifact.getGroupId()));
        sb.append(String.format("                <artifactId>%s</artifactId>\n", artifact.getArtifactId()));
        sb.append(String.format("                <version>%s</version>\n", artifact.getVersionString()));
        if (artifact.getClassifier() != null) {
            sb.append(String.format("                <classifier>%s</classifier>\n", artifact.getClassifier()));
        }
        if (!"jar".equals(artifact.getType())) {
            sb.append(String.format("                <type>%s</type>\n", artifact.getType()));
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            sb.append("                <exclusions>\n");
            for (ProjectRef e : exclusions) {
                sb.append("                    <exclusion>\n");
                sb.append("                        <groupId>" + e.getGroupId() + "</groupId>\n");
                sb.append("                        <artifactId>" + e.getArtifactId() + "</artifactId>\n");
                sb.append("                    </exclusion>\n");
            }
            sb.append("                </exclusions>\n");
        }
        sb.append("            </dependency>\n");
        return sb.toString();
    }

    private static String composeRepositoryElementString(String id, String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("    <repository>\n");
        sb.append(String.format("            <id>%s</id>\n", id));
        sb.append(String.format("            <url>%s</url>\n", url));
        sb.append("            <releases>\n");
        sb.append("                <enabled>true</enabled>\n");
        sb.append("                <updatePolicy>always</updatePolicy>\n");
        sb.append("            </releases>\n");
        sb.append("            <snapshots>\n");
        sb.append("                <enabled>true</enabled>\n");
        sb.append("                <updatePolicy>always</updatePolicy>\n");
        sb.append("            </snapshots>\n");
        sb.append("        </repository>\n");
        return sb.toString();
    }
}

