/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedList;

public class PriorityLinkedListImpl<E>
implements PriorityLinkedList<E> {
    private static final AtomicIntegerFieldUpdater<PriorityLinkedListImpl> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PriorityLinkedListImpl.class, "size");
    protected final LinkedListImpl<E>[] levels;
    private volatile int size;
    private int lastReset;
    private int highestPriority = -1;
    private int lastPriority = -1;

    public PriorityLinkedListImpl(int priorities) {
        this(priorities, null);
    }

    public PriorityLinkedListImpl(int priorities, Comparator<E> comparator) {
        this.levels = (LinkedListImpl[])Array.newInstance(LinkedListImpl.class, priorities);
        for (int i = 0; i < priorities; ++i) {
            this.levels[i] = new LinkedListImpl<E>(comparator);
        }
    }

    private void checkHighest(int priority) {
        if (this.lastPriority != priority || priority > this.highestPriority) {
            this.lastPriority = priority;
            this.lastReset = this.lastReset == Integer.MAX_VALUE ? 0 : ++this.lastReset;
        }
        if (priority > this.highestPriority) {
            this.highestPriority = priority;
        }
    }

    @Override
    public void addHead(E e, int priority) {
        this.checkHighest(priority);
        this.levels[priority].addHead(e);
        this.exclusiveIncrementSize(1);
    }

    @Override
    public void addTail(E e, int priority) {
        this.checkHighest(priority);
        this.levels[priority].addTail(e);
        this.exclusiveIncrementSize(1);
    }

    @Override
    public void addSorted(E e, int priority) {
        this.checkHighest(priority);
        this.levels[priority].addSorted(e);
        this.exclusiveIncrementSize(1);
    }

    @Override
    public void setNodeStore(NodeStore<E> supplier) {
        for (LinkedListImpl<E> list : this.levels) {
            list.setNodeStore(supplier);
        }
    }

    @Override
    public E removeWithID(String listID, long id) {
        E removed;
        int l;
        if (this.levels.length > 4) {
            for (l = 4; l < this.levels.length; ++l) {
                removed = this.levels[l].removeWithID(listID, id);
                if (removed == null) continue;
                this.exclusiveIncrementSize(-1);
                return removed;
            }
        }
        for (l = Math.min(3, this.levels.length); l >= 0; --l) {
            removed = this.levels[l].removeWithID(listID, id);
            if (removed == null) continue;
            this.exclusiveIncrementSize(-1);
            return removed;
        }
        return null;
    }

    @Override
    public E poll() {
        E e = null;
        for (int i = this.highestPriority; i >= 0; --i) {
            LinkedListImpl<E> ll = this.levels[i];
            if (ll.size() == 0) continue;
            e = ll.poll();
            if (e == null) break;
            this.exclusiveIncrementSize(-1);
            if (ll.size() != 0 || this.highestPriority != i) break;
            --this.highestPriority;
            break;
        }
        return e;
    }

    @Override
    public void clear() {
        for (LinkedListImpl<E> list : this.levels) {
            list.clear();
        }
        this.exclusiveSetSize(0);
    }

    private void exclusiveIncrementSize(int amount) {
        SIZE_UPDATER.lazySet(this, this.size + amount);
    }

    private void exclusiveSetSize(int value) {
        SIZE_UPDATER.lazySet(this, value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public LinkedListIterator<E> iterator() {
        return new PriorityLinkedListIterator();
    }

    private class PriorityLinkedListIterator
    implements LinkedListIterator<E> {
        private int index;
        private final LinkedListIterator<E>[] cachedIters;
        private LinkedListIterator<E> lastIter;
        private int resetCount;
        volatile boolean closed;

        PriorityLinkedListIterator() {
            this.cachedIters = new LinkedListIterator[PriorityLinkedListImpl.this.levels.length];
            this.resetCount = PriorityLinkedListImpl.this.lastReset;
            this.closed = false;
            this.index = PriorityLinkedListImpl.this.levels.length - 1;
        }

        @Override
        public void repeat() {
            if (this.lastIter == null) {
                throw new NoSuchElementException();
            }
            this.lastIter.repeat();
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.lastIter = null;
                for (LinkedListIterator iter : this.cachedIters) {
                    if (iter == null) continue;
                    iter.close();
                }
            }
        }

        private void checkReset() {
            if (PriorityLinkedListImpl.this.lastReset != this.resetCount) {
                this.index = PriorityLinkedListImpl.this.highestPriority;
                this.resetCount = PriorityLinkedListImpl.this.lastReset;
            }
        }

        @Override
        public boolean hasNext() {
            this.checkReset();
            while (this.index >= 0) {
                boolean b;
                this.lastIter = this.cachedIters[this.index];
                if (this.lastIter == null) {
                    this.cachedIters[this.index] = PriorityLinkedListImpl.this.levels[this.index].iterator();
                    this.lastIter = this.cachedIters[this.index];
                }
                if (b = this.lastIter.hasNext()) {
                    return true;
                }
                --this.index;
                if (this.index >= 0) continue;
                this.index = PriorityLinkedListImpl.this.levels.length - 1;
                break;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.lastIter == null) {
                throw new NoSuchElementException();
            }
            return this.lastIter.next();
        }

        @Override
        public void remove() {
            if (this.lastIter == null) {
                throw new NoSuchElementException();
            }
            this.lastIter.remove();
            int i = this.index;
            while (i >= 0 && PriorityLinkedListImpl.this.levels[this.index].size() == 0) {
                PriorityLinkedListImpl.this.highestPriority = i--;
            }
            PriorityLinkedListImpl.this.exclusiveIncrementSize(-1);
        }
    }
}

