/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import jakarta.ejb.NoSuchEJBException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.ejb._private.Keys;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DiscoveredURISelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.NamingEJBClientInterceptor;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SecurityUtils;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.common.Assert;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.ServicesQueue;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.security.auth.client.AuthenticationContext;

@ClientInterceptorPriority(value=200100)
public final class DiscoveryEJBClientInterceptor
implements EJBClientInterceptor {
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(Discovery.getContextManager()::getPrivilegedSupplier);
    private static final String[] NO_STRINGS = new String[0];
    private static final boolean WILDFLY_TESTSUITE_HACK = SecurityUtils.getBoolean("org.jboss.ejb.client.wildfly-testsuite-hack");
    private static final long DISCOVERY_TIMEOUT = SecurityUtils.getLong("org.jboss.ejb.client.discovery.timeout", 0L);
    private static final long DISCOVERY_ADDITIONAL_TIMEOUT = SecurityUtils.getLong("org.jboss.ejb.client.discovery.additional-node-timeout", 0L);
    public static final int PRIORITY = 200100;
    private static final AttachmentKey<Set<URI>> BL_KEY = new AttachmentKey();
    private static final Map<URI, Long> blocklist = new ConcurrentHashMap<URI, Long>();
    private static final long BLOCKLIST_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(SecurityUtils.getLong("org.jboss.ejb.client.discovery.blacklist.timeout", 5000L));

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        if (context.getDestination() != null) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: calling handleInvocation - destination already discovered (destination = %s)", (Object)context.getDestination());
            }
            context.sendRequest();
            return;
        }
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: calling handleInvocation - calling executeDiscovery", new Object[0]);
        }
        List<Throwable> problems = this.executeDiscovery(context);
        if (WILDFLY_TESTSUITE_HACK && context.getDestination() == null) {
            Thread.sleep(2000L);
            problems = this.executeDiscovery(context);
        }
        try {
            context.sendRequest();
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            this.processMissingTarget(context, e);
            throw e;
        }
        finally {
            if (problems != null) {
                for (Throwable problem : problems) {
                    context.addSuppressed(problem);
                }
            }
        }
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        Object result;
        try {
            result = context.getResult();
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: handleInvocationResult: (exception = %s)", (Object)e.getMessage());
            }
            this.processMissingTarget(context, e);
            throw e;
        }
        EJBLocator<?> locator = context.getLocator();
        if (locator.isStateful() && locator.getAffinity() instanceof ClusterAffinity && context.getWeakAffinity() == Affinity.NONE) {
            Affinity targetAffinity = context.getTargetAffinity();
            if (targetAffinity != null) {
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: calling handleInvocationResult - stateful, clustered case, setting weakAffinity to targetAffinty = %s", (Object)targetAffinity);
                }
                context.setWeakAffinity(targetAffinity);
            } else {
                URI destination = context.getDestination();
                if (destination != null) {
                    if (Logs.INVOCATION.isDebugEnabled()) {
                        Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: calling handleInvocationResult - stateful, clustered case, setting weakAffinity to URIAffintiy = %s", (Object)URIAffinity.forUri(destination));
                    }
                    context.setWeakAffinity(URIAffinity.forUri(destination));
                }
            }
        }
        return result;
    }

    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        SessionID sessionID;
        Logs.INVOCATION.tracef("DiscoveryEJBClientInterceptor: calling handleSessionCreation (locator = %s, weak affinity = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity());
        if (context.getDestination() != null) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: calling handleSessionCreation - destination already discovered (destination = %s)", (Object)context.getDestination());
            }
            return context.proceed();
        }
        List<Throwable> problems = this.executeDiscovery(context);
        if (WILDFLY_TESTSUITE_HACK && context.getDestination() == null) {
            Thread.sleep(2000L);
            problems = this.executeDiscovery(context);
        }
        try {
            sessionID = context.proceed();
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            this.processMissingTarget(context, e);
            throw EJBClientContext.withSuppressed(e, problems);
        }
        catch (Exception t) {
            throw EJBClientContext.withSuppressed(t, problems);
        }
        DiscoveryEJBClientInterceptor.setupSessionAffinities(context);
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: session affinities have been setup (locator = %s, weak affinity = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity());
        }
        return sessionID;
    }

    public static long getDiscoveryAdditionalTimeout() {
        return DISCOVERY_ADDITIONAL_TIMEOUT;
    }

    static void setupSessionAffinities(EJBSessionCreationInvocationContext context) {
        URI destination;
        Affinity targetAffinity;
        EJBLocator<?> locator = context.getLocator();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: setting up session affinities for new session bean: (locator = %s, weak affinity = %s, targetAffinity = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)context.getTargetAffinity());
        }
        if (locator.getAffinity() == Affinity.NONE) {
            targetAffinity = context.getTargetAffinity();
            if (targetAffinity != null) {
                context.setLocator(locator.withNewAffinity(targetAffinity));
            } else {
                destination = context.getDestination();
                if (destination != null) {
                    context.setLocator(locator.withNewAffinity(URIAffinity.forUri(destination)));
                }
            }
        }
        if (locator.getAffinity() instanceof ClusterAffinity && context.getWeakAffinity() == Affinity.NONE) {
            targetAffinity = context.getTargetAffinity();
            if (targetAffinity != null) {
                context.setWeakAffinity(targetAffinity);
            } else {
                destination = context.getDestination();
                if (destination != null) {
                    context.setWeakAffinity(URIAffinity.forUri(destination));
                }
            }
        }
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: set up session affinities for new session bean: (locator = %s, weak affinity = %s, targetAffinity = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)context.getTargetAffinity());
        }
    }

    private void processMissingTarget(AbstractInvocationContext context, Exception cause) {
        URI destination = context.getDestination();
        if (destination == null || context.getTargetAffinity() == Affinity.LOCAL) {
            return;
        }
        if (DiscoveryEJBClientInterceptor.shouldBlocklist(cause)) {
            DiscoveryEJBClientInterceptor.addBlocklistedDestination(destination);
        } else {
            DiscoveryEJBClientInterceptor.addInvocationBlocklistedDestination(context, destination);
        }
        this.getDiscovery().processMissingTarget(destination, cause);
        context.setWeakAffinity(Affinity.NONE);
        context.setTargetAffinity(null);
        context.setDestination(null);
        context.requestRetry();
    }

    static boolean shouldBlocklist(Exception cause) {
        return cause instanceof RequestSendFailedException && cause.getCause() instanceof ConnectException;
    }

    static void addInvocationBlocklistedDestination(AbstractInvocationContext context, URI destination) {
        Assert.checkNotNullParam("context", context);
        if (destination != null) {
            Set appearing;
            Set set = context.getAttachment(BL_KEY);
            if (set == null && (appearing = (Set)context.putAttachmentIfAbsent(BL_KEY, set = new HashSet<URI>())) != null) {
                set = appearing;
            }
            set.add((URI)destination);
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: blocklisting destination for this invocation (locator = %s, weak affinity = %s, missing target = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)destination);
            }
        }
    }

    static void addBlocklistedDestination(URI destination) {
        if (destination != null) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: blocklisting destination %s", (Object)destination);
            }
            blocklist.put(destination, System.nanoTime());
        }
    }

    static boolean isBlocklisted(AbstractInvocationContext context, URI destination) {
        Set<URI> invocationBlocklist = context.getAttachment(BL_KEY);
        if (invocationBlocklist != null && invocationBlocklist.contains(destination)) {
            return true;
        }
        if (!blocklist.containsKey(destination)) {
            return false;
        }
        return DiscoveryEJBClientInterceptor.getBlocklist().contains(destination);
    }

    static Set<URI> getBlocklist() {
        blocklist.entrySet().removeIf(e -> System.nanoTime() - (Long)e.getValue() > BLOCKLIST_TIMEOUT);
        return blocklist.keySet();
    }

    ServicesQueue discover(AbstractInvocationContext invocationContext, FilterSpec filterSpec) {
        AuthenticationContext authenticationContext = invocationContext.getAuthenticationContext();
        return authenticationContext != null ? authenticationContext.runBiFunction(DiscoveryEJBClientInterceptor::discover, this, filterSpec) : this.discover(filterSpec);
    }

    ServicesQueue discover(FilterSpec filterSpec) {
        return this.getDiscovery().discover(EJBClientContext.EJB_SERVICE_TYPE, filterSpec);
    }

    Discovery getDiscovery() {
        return DISCOVERY_SUPPLIER.get();
    }

    private List<Throwable> executeDiscovery(AbstractInvocationContext context) {
        assert (context.getDestination() == null);
        EJBLocator<?> locator = context.getLocator();
        Affinity affinity = locator.getAffinity();
        Affinity weakAffinity = context.getWeakAffinity();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: calling executeDiscovery(locator = %s, weak affinity = %s)", (Object)locator, (Object)weakAffinity);
        }
        if (affinity instanceof URIAffinity || affinity == Affinity.LOCAL) {
            if (!DiscoveryEJBClientInterceptor.isBlocklisted(context, affinity.getUri())) {
                context.setDestination(affinity.getUri());
                context.setTargetAffinity(affinity);
            }
            return null;
        }
        if (affinity == Affinity.NONE && weakAffinity instanceof URIAffinity) {
            if (!DiscoveryEJBClientInterceptor.isBlocklisted(context, weakAffinity.getUri())) {
                context.setDestination(weakAffinity.getUri());
                context.setTargetAffinity(weakAffinity);
            }
            return null;
        }
        if (affinity == Affinity.NONE && weakAffinity instanceof NodeAffinity) {
            FilterSpec filterSpec = FilterSpec.all(FilterSpec.equal("node", ((NodeAffinity)weakAffinity).getNodeName()), this.getFilterSpec(locator.getIdentifier().getModuleIdentifier()));
            return this.doFirstMatchDiscovery(context, filterSpec, null);
        }
        if (affinity instanceof NodeAffinity) {
            FilterSpec filterSpec = FilterSpec.all(FilterSpec.equal("node", ((NodeAffinity)affinity).getNodeName()), this.getFilterSpec(locator.getIdentifier().getModuleIdentifier()));
            return this.doFirstMatchDiscovery(context, filterSpec, null);
        }
        if (affinity instanceof ClusterAffinity) {
            if (weakAffinity instanceof NodeAffinity) {
                FilterSpec filterSpec = FilterSpec.all(FilterSpec.equal("cluster", ((ClusterAffinity)affinity).getClusterName()), FilterSpec.equal("node", ((NodeAffinity)weakAffinity).getNodeName()), this.getFilterSpec(locator.getIdentifier().getModuleIdentifier()));
                FilterSpec fallbackFilterSpec = FilterSpec.all(FilterSpec.equal("cluster", ((ClusterAffinity)affinity).getClusterName()), FilterSpec.hasAttribute("node"), this.getFilterSpec(locator.getIdentifier().getModuleIdentifier()));
                return this.doFirstMatchDiscovery(context, filterSpec, fallbackFilterSpec);
            }
            if (weakAffinity instanceof URIAffinity || weakAffinity == Affinity.LOCAL) {
                context.setDestination(weakAffinity.getUri());
                context.setTargetAffinity(weakAffinity);
                return null;
            }
            FilterSpec filterSpec = FilterSpec.all(FilterSpec.equal("cluster", ((ClusterAffinity)affinity).getClusterName()), this.getFilterSpec(locator.getIdentifier().getModuleIdentifier()));
            return this.doClusterDiscovery(context, filterSpec);
        }
        assert (affinity == Affinity.NONE);
        FilterSpec filterSpec = this.getFilterSpec(locator.getIdentifier().getModuleIdentifier());
        return this.doAnyDiscovery(context, filterSpec, locator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Throwable> doFirstMatchDiscovery(AbstractInvocationContext context, FilterSpec filterSpec, FilterSpec fallbackFilterSpec) {
        List<Throwable> problems;
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performing first-match discovery(locator = %s, weak affinity = %s, filter spec = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)filterSpec);
        }
        Set<URI> blocklist = DiscoveryEJBClientInterceptor.getBlocklist();
        try (ServicesQueue queue = this.discover(context, filterSpec);){
            ServiceURL serviceURL;
            while ((serviceURL = queue.takeService(DISCOVERY_TIMEOUT, TimeUnit.SECONDS)) != null) {
                URI location = serviceURL.getLocationURI();
                if (blocklist.contains(location)) continue;
                AttributeValue nodeValue = serviceURL.getFirstAttributeValue("node");
                if (nodeValue != null) {
                    context.setTargetAffinity(new NodeAffinity(nodeValue.toString()));
                } else {
                    context.setTargetAffinity(URIAffinity.forUri(location));
                }
                context.setDestination(location);
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed first-match discovery(target affinity = %s, destination = %s)", (Object)context.getTargetAffinity(), (Object)context.getDestination());
                }
                List<Throwable> list = queue.getProblems();
                return list;
            }
            problems = queue.getProblems();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
        if (fallbackFilterSpec == null) {
            if (!Logs.INVOCATION.isDebugEnabled()) return problems;
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed first-match discovery, no match", new Object[0]);
            return problems;
        }
        assert (context.getLocator().getAffinity() instanceof ClusterAffinity);
        if (!Logs.INVOCATION.isDebugEnabled()) return DiscoveryEJBClientInterceptor.merge(problems, this.doClusterDiscovery(context, fallbackFilterSpec));
        Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed first-match discovery, no match, falling back to cluster discovery", new Object[0]);
        return DiscoveryEJBClientInterceptor.merge(problems, this.doClusterDiscovery(context, fallbackFilterSpec));
    }

    private static List<Throwable> merge(List<Throwable> problems, List<Throwable> problems2) {
        if (problems2.isEmpty()) {
            return problems;
        }
        if (problems.isEmpty()) {
            return problems2;
        }
        ArrayList<Throwable> problems3 = new ArrayList<Throwable>(problems.size() + problems2.size());
        problems3.addAll(problems);
        problems3.addAll(problems2);
        return problems3;
    }

    private List<Throwable> doAnyDiscovery(AbstractInvocationContext context, FilterSpec filterSpec, EJBLocator<?> locator) {
        Object selector;
        String nodeName;
        URI location;
        List<Throwable> problems;
        Logs.INVOCATION.tracef("DiscoveryEJBClientInterceptor: performing any discovery(locator = %s, weak affinity = %s, filter spec = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)filterSpec);
        Set<URI> blocklist = DiscoveryEJBClientInterceptor.getBlocklist();
        HashMap<URI, String> nodes = new HashMap<URI, String>();
        HashMap<String, URI> uris = new HashMap<String, URI>();
        HashMap<URI, List<String>> clusterAssociations = new HashMap<URI, List<String>>();
        int nodeless = 0;
        long timeout = DISCOVERY_TIMEOUT * 1000L;
        try (ServicesQueue queue = this.discover(context, filterSpec);){
            ServiceURL serviceURL;
            while ((serviceURL = queue.takeService(timeout, TimeUnit.MILLISECONDS)) != null) {
                URI location2 = serviceURL.getLocationURI();
                if (blocklist.contains(location2)) continue;
                AttributeValue nodeValue = serviceURL.getFirstAttributeValue("node");
                if (nodeValue != null) {
                    if (nodes.remove(location2, null)) {
                        --nodeless;
                    }
                    String nodeName2 = nodeValue.toString();
                    nodes.put(location2, nodeName2);
                    if (!uris.containsKey(nodeName2) || location2.equals(Affinity.LOCAL.getUri())) {
                        uris.put(nodeName2, location2);
                    }
                } else if (nodes.putIfAbsent(location2, null) == null) {
                    ++nodeless;
                }
                List<AttributeValue> clusters = serviceURL.getAttributeValues("cluster");
                if (clusters != null) {
                    for (AttributeValue cluster : clusters) {
                        List<String> list = clusterAssociations.putIfAbsent(location2, Collections.singletonList(cluster.toString()));
                        if (list == null) continue;
                        if (!(list instanceof ArrayList)) {
                            list = new ArrayList<String>(list);
                            clusterAssociations.put(location2, list);
                        }
                        list.add(cluster.toString());
                    }
                }
                if (DISCOVERY_ADDITIONAL_TIMEOUT == 0L) continue;
                timeout = DISCOVERY_ADDITIONAL_TIMEOUT;
            }
            problems = queue.getProblems();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
        if (nodes.isEmpty()) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed any discovery, no match", new Object[0]);
            }
            return problems;
        }
        if (nodes.size() == 1) {
            Map.Entry entry = nodes.entrySet().iterator().next();
            location = (URI)entry.getKey();
            nodeName = (String)entry.getValue();
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed any discovery(target affinity(node) = %s, destination = %s)", (Object)nodeName, (Object)location);
            }
        } else if (nodeless == 0) {
            selector = context.getClientContext().getDeploymentNodeSelector();
            nodeName = selector.selectNode(nodes.values().toArray(NO_STRINGS), locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
            if (nodeName == null) {
                throw Logs.INVOCATION.selectorReturnedNull(selector);
            }
            location = (URI)uris.get(nodeName);
            if (location == null) {
                throw Logs.INVOCATION.selectorReturnedUnknownNode(selector, nodeName);
            }
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed any discovery, nodes > 1, deployment selector used(target affinity(node) = %s, destination = %s)", (Object)nodeName, (Object)location);
            }
        } else {
            selector = DiscoveredURISelector.RANDOM;
            location = selector.selectNode(new ArrayList<URI>(nodes.keySet()), locator);
            if (location == null) {
                throw Logs.INVOCATION.selectorReturnedNull(selector);
            }
            nodeName = (String)nodes.get(location);
            if (nodeName == null) {
                throw Logs.INVOCATION.selectorReturnedUnknownNode(selector, location.toString());
            }
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed any discovery, nodes > 1, URI selector used(target affinity(node) = %s, destination = %s)", (Object)nodeName, (Object)location);
            }
        }
        this.selectCluster(context, clusterAssociations, location);
        context.setDestination(location);
        if (nodeName != null) {
            context.setTargetAffinity(new NodeAffinity(nodeName));
        }
        return problems;
    }

    private void selectCluster(AbstractInvocationContext context, Map<URI, List<String>> clusterAssociations, URI location) {
        List<String> associations = clusterAssociations.get(location);
        String cluster = null;
        if (associations != null) {
            String string = cluster = associations.size() == 1 ? associations.get(0) : associations.get(ThreadLocalRandom.current().nextInt(associations.size()));
        }
        if (cluster != null) {
            context.setInitialCluster(cluster);
        }
    }

    private List<Throwable> doClusterDiscovery(AbstractInvocationContext context, FilterSpec filterSpec) {
        List<Throwable> problems;
        Logs.INVOCATION.tracef("DiscoveryEJBClientInterceptor: performing cluster discovery(locator = %s, weak affinity = %s, filter spec = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)filterSpec);
        Map<String, URI> nodes = new HashMap<String, URI>();
        EJBClientContext clientContext = context.getClientContext();
        Set<URI> blocklist = DiscoveryEJBClientInterceptor.getBlocklist();
        long timeout = DISCOVERY_TIMEOUT * 1000L;
        try (ServicesQueue queue = this.discover(context, filterSpec);){
            ServiceURL serviceURL;
            while ((serviceURL = queue.takeService(timeout, TimeUnit.MILLISECONDS)) != null) {
                AttributeValue attributeValue;
                EJBReceiver transportProvider;
                URI location = serviceURL.getLocationURI();
                if (blocklist.contains(location) || (transportProvider = clientContext.getTransportProvider(location.getScheme())) == null || !this.satisfiesSourceAddress(serviceURL, transportProvider) || (attributeValue = serviceURL.getFirstAttributeValue("node")) == null) continue;
                nodes.put(attributeValue.toString(), location);
                if (DISCOVERY_ADDITIONAL_TIMEOUT == 0L) continue;
                timeout = DISCOVERY_ADDITIONAL_TIMEOUT;
            }
            problems = queue.getProblems();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
        nodes = this.tryFilterToPreferredNodes(context, nodes);
        EJBLocator<?> locator = context.getLocator();
        if (nodes.isEmpty()) {
            NamingProvider namingProvider;
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed cluster discovery, nodes is empty; trying an initial ", new Object[0]);
            }
            if ((namingProvider = context.getAttachment(Keys.NAMING_PROVIDER_ATTACHMENT_KEY)) != null) {
                NamingEJBClientInterceptor.setNamingDestination(context, namingProvider);
            }
            return problems;
        }
        if (nodes.size() == 1) {
            Map.Entry<String, URI> entry = nodes.entrySet().iterator().next();
            String nodeName = entry.getKey();
            URI uri = entry.getValue();
            context.setTargetAffinity(new NodeAffinity(nodeName));
            context.setDestination(uri);
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed cluster discovery, single node case (target affinity = %s, destination = %s)", (Object)context.getTargetAffinity(), (Object)context.getDestination());
            }
            return problems;
        }
        ArrayList<String> availableNodes = new ArrayList<String>(nodes.size());
        ArrayList<String> connectedNodes = new ArrayList<String>(nodes.size());
        for (Map.Entry entry : nodes.entrySet()) {
            String nodeName = (String)entry.getKey();
            URI uri = (URI)entry.getValue();
            EJBReceiver transportProvider = clientContext.getTransportProvider(uri.getScheme());
            if (transportProvider == null) continue;
            availableNodes.add(nodeName);
            if (!transportProvider.isConnected(uri)) continue;
            connectedNodes.add(nodeName);
        }
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performing cluster discovery, multi node case (connected nodes = %s, available nodes = %s)", (Object)connectedNodes, (Object)availableNodes);
        }
        ClusterNodeSelector selector = clientContext.getClusterNodeSelector();
        String string = selector.selectNode(((ClusterAffinity)locator.getAffinity()).getClusterName(), connectedNodes.toArray(NO_STRINGS), availableNodes.toArray(NO_STRINGS));
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performing cluster discovery, multi-node case (cluster node selector = %s, selected node = %s)", (Object)selector.getClass().getName(), (Object)string);
        }
        if (string == null) {
            throw EJBClientContext.withSuppressed(Logs.MAIN.selectorReturnedNull(selector), problems);
        }
        URI uri = nodes.get(string);
        if (uri == null) {
            throw EJBClientContext.withSuppressed(Logs.MAIN.selectorReturnedUnknownNode(selector, string), problems);
        }
        context.setDestination(uri);
        context.setTargetAffinity(new NodeAffinity(string));
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("DiscoveryEJBClientInterceptor: performed cluster discovery (target affinity = %s, destination = %s)", (Object)context.getTargetAffinity(), (Object)context.getDestination());
        }
        return problems;
    }

    private Map<String, URI> tryFilterToPreferredNodes(AbstractInvocationContext context, Map<String, URI> nodes) {
        Collection<URI> attachment = context.getAttachment(TransactionInterceptor.PREFERRED_DESTINATIONS);
        if (attachment == null) {
            return nodes;
        }
        HashSet<URI> preferred = new HashSet<URI>(attachment);
        HashMap<String, URI> result = null;
        for (Map.Entry<String, URI> check : nodes.entrySet()) {
            if (!preferred.contains(check.getValue())) continue;
            if (result == null) {
                result = new HashMap<String, URI>(attachment.size());
            }
            result.put(check.getKey(), check.getValue());
        }
        return result == null ? nodes : result;
    }

    FilterSpec getFilterSpec(EJBModuleIdentifier identifier) {
        String appName = identifier.getAppName();
        String moduleName = identifier.getModuleName();
        String distinctName = identifier.getDistinctName();
        if (distinctName != null && !distinctName.isEmpty()) {
            if (appName.isEmpty()) {
                return FilterSpec.equal("ejb-module-distinct", moduleName + '/' + distinctName);
            }
            return FilterSpec.equal("ejb-module-distinct", appName + '/' + moduleName + '/' + distinctName);
        }
        if (appName.isEmpty()) {
            return FilterSpec.equal("ejb-module", moduleName);
        }
        return FilterSpec.equal("ejb-module", appName + '/' + moduleName);
    }

    boolean satisfiesSourceAddress(ServiceURL serviceURL, EJBReceiver receiver) {
        List<AttributeValue> values = serviceURL.getAttributeValues("source-ip");
        if (values.isEmpty()) {
            return true;
        }
        URI uri = serviceURL.getLocationURI();
        InetSocketAddress sourceAddress = receiver.getSourceAddress(new InetSocketAddress(uri.getHost(), uri.getPort()));
        InetAddress inetAddress = sourceAddress != null ? sourceAddress.getAddress() : null;
        for (AttributeValue value : values) {
            CidrAddress matchAddress;
            if (!value.isString() || (matchAddress = Inet.parseCidrAddress(value.toString())) == null || !(inetAddress == null ? matchAddress.getNetmaskBits() == 0 : matchAddress.matches(inetAddress))) continue;
            return true;
        }
        return false;
    }
}

