/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.RawPassword;
import org.wildfly.security.password.interfaces.UnixMD5CryptPassword;

class RawUnixMD5CryptPassword
extends RawPassword
implements UnixMD5CryptPassword {
    private static final long serialVersionUID = 4011217552590161658L;
    private final byte[] salt;
    private final byte[] hash;

    RawUnixMD5CryptPassword(String algorithm, byte[] salt, byte[] hash) {
        super(algorithm);
        this.salt = salt;
        this.hash = hash;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public RawUnixMD5CryptPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(Arrays.hashCode(this.hash), Arrays.hashCode(this.salt));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawUnixMD5CryptPassword)) {
            return false;
        }
        RawUnixMD5CryptPassword other = (RawUnixMD5CryptPassword)obj;
        return Arrays.equals(this.hash, other.hash) && Arrays.equals(this.salt, other.salt);
    }
}

