/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.spi;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import org.wildfly.common.Assert;
import org.wildfly.transaction.client._private.Log;

public interface SimpleTransactionControl {
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

    public void rollback() throws SecurityException, SystemException;

    default public void setRollbackOnly() throws SystemException {
    }

    default public void safeRollback() {
        try {
            this.rollback();
        }
        catch (SystemException | SecurityException e) {
            Log.log.rollbackFailed(e);
        }
    }

    public static SimpleTransactionControl of(final Transaction transaction) {
        Assert.checkNotNullParam("transaction", transaction);
        return new SimpleTransactionControl(){

            @Override
            public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
                transaction.commit();
            }

            @Override
            public void rollback() throws SecurityException, SystemException {
                transaction.rollback();
            }

            @Override
            public void setRollbackOnly() throws SystemException {
                transaction.setRollbackOnly();
            }

            @Override
            public <T> T getProviderInterface(Class<T> providerInterfaceType) {
                return providerInterfaceType.isInstance(transaction) ? (T)providerInterfaceType.cast(transaction) : null;
            }
        };
    }

    public <T> T getProviderInterface(Class<T> var1);
}

