/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Optional;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class ReadAttributeTranslationHandler
implements OperationStepHandler {
    private final Attribute targetAttribute;
    private final AttributeValueTranslator translator;

    public ReadAttributeTranslationHandler(AttributeTranslation translation) {
        this(translation.getTargetAttribute(), translation.getReadTranslator());
    }

    public ReadAttributeTranslationHandler(Attribute targetAttribute, AttributeValueTranslator translator) {
        this.targetAttribute = targetAttribute;
        this.translator = translator;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode targetOperation = Operations.createReadAttributeOperation(context.getCurrentAddress(), this.targetAttribute);
        String targetName = this.targetAttribute.getName();
        Optional.ofNullable(context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, targetName).getReadHandler()).orElse((ctx, op) -> {
            ModelNode model = ctx.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode result = ctx.getResult();
            if (model.hasDefined(targetName)) {
                result.set(model.get(targetName));
            } else if (Operations.isIncludeDefaults(op)) {
                result.set(((AttributeDefinition)this.targetAttribute.getDefinition()).getDefaultValue());
            }
        }).execute(context, targetOperation);
        ModelNode result = context.getResult();
        result.set(this.translator.translate(context, result));
    }
}

