/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.persistence;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PersistentResourceXMLDescription;

public class AttributeXMLBuilderOperator
implements UnaryOperator<PersistentResourceXMLDescription.PersistentResourceXMLBuilder> {
    private final List<Attribute> attributes;

    public AttributeXMLBuilderOperator() {
        this.attributes = new LinkedList<Attribute>();
    }

    public <A extends Enum<A>> AttributeXMLBuilderOperator(Class<A> attributeClass) {
        this.attributes = new ArrayList<A>(EnumSet.allOf(attributeClass));
    }

    public <A extends Enum<A>> AttributeXMLBuilderOperator addAttributes(Class<A> attributeClass) {
        return this.addAttributes(EnumSet.allOf(attributeClass));
    }

    public <A extends Attribute> AttributeXMLBuilderOperator addAttributes(Set<A> attributes) {
        this.attributes.addAll(attributes);
        return this;
    }

    @Override
    public PersistentResourceXMLDescription.PersistentResourceXMLBuilder apply(PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder) {
        LinkedList<AttributeDefinition> elementAttributes = new LinkedList<AttributeDefinition>();
        for (Attribute attribute : this.attributes) {
            AttributeDefinition definition = (AttributeDefinition)attribute.getDefinition();
            if (definition.getParser().isParseAsElement()) {
                elementAttributes.add(definition);
                continue;
            }
            builder.addAttribute(definition, definition.getParser(), definition.getMarshaller());
        }
        for (AttributeDefinition attributeDefinition : elementAttributes) {
            builder.addAttribute(attributeDefinition, attributeDefinition.getParser(), attributeDefinition.getMarshaller());
        }
        return builder;
    }
}

