/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.offset;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.cache.offset.Offset;
import org.wildfly.clustering.ee.cache.offset.Value;
import org.wildfly.common.function.Functions;

public interface OffsetValue<V>
extends Value<V> {
    public V getBasis();

    @Override
    default public V get() {
        return (V)this.getOffset().apply(this.getBasis());
    }

    public Offset<V> getOffset();

    default public void setOffset(Offset<V> offset) {
        this.set(offset.apply(this.getBasis()));
    }

    public OffsetValue<V> rebase();

    public static OffsetValue<Duration> from(Duration duration) {
        return new DurationOffsetValue(Functions.constantSupplier((Object)duration));
    }

    public static OffsetValue<Instant> from(Instant instant) {
        return new InstantOffsetValue(Functions.constantSupplier((Object)instant));
    }

    public static class DurationOffsetValue
    extends TemporalOffsetValue<Duration> {
        private static final BiFunction<Duration, Duration, Duration> MINUS = Duration::minus;
        private static final BiFunction<Duration, Duration, Duration> FACTORY = MINUS.andThen(Duration::negated);

        DurationOffsetValue(Supplier<Duration> basis) {
            super(basis, FACTORY, Offset::forDuration, DurationOffsetValue::new);
        }
    }

    public static class InstantOffsetValue
    extends TemporalOffsetValue<Instant> {
        private static final BiFunction<Instant, Instant, Duration> FACTORY = Duration::between;

        InstantOffsetValue(Supplier<Instant> basis) {
            super(basis, FACTORY, Offset::forInstant, InstantOffsetValue::new);
        }
    }

    public static class TemporalOffsetValue<V>
    extends DefaultOffsetValue<Duration, V> {
        TemporalOffsetValue(Supplier<V> basis, BiFunction<V, V, Duration> factory, Function<Duration, Offset<V>> offsetFactory, Function<Supplier<V>, OffsetValue<V>> offsetValueFactory) {
            super(basis, Duration.ZERO, factory, offsetFactory, offsetValueFactory);
        }
    }

    public static class DefaultOffsetValue<O, V>
    extends Value.AbstractValue<V>
    implements OffsetValue<V> {
        private final BiFunction<V, V, O> factory;
        private final Function<O, Offset<V>> offsetFactory;
        private final Function<Supplier<V>, OffsetValue<V>> offsetValueFactory;
        private final Supplier<V> basis;
        private final O zero;
        private volatile Offset<V> offset;

        DefaultOffsetValue(Supplier<V> basis, O zero, BiFunction<V, V, O> factory, Function<O, Offset<V>> offsetFactory, Function<Supplier<V>, OffsetValue<V>> offsetValueFactory) {
            this.factory = factory;
            this.offsetFactory = offsetFactory;
            this.offsetValueFactory = offsetValueFactory;
            this.zero = zero;
            this.basis = basis;
            this.offset = this.offsetFactory.apply(zero);
        }

        @Override
        public V getBasis() {
            return this.basis.get();
        }

        @Override
        public void set(V value) {
            V basis = this.getBasis();
            this.offset = this.offsetFactory.apply(Objects.equals(basis, value) ? this.zero : this.factory.apply(basis, value));
        }

        @Override
        public void setOffset(Offset<V> offset) {
            this.offset = offset;
        }

        @Override
        public Offset<V> getOffset() {
            return this.offset;
        }

        @Override
        public OffsetValue<V> rebase() {
            return this.offsetValueFactory.apply(this);
        }
    }
}

