/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jboss.ejb.client.BasicSessionID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.jboss.ejb.client.UnknownSessionID;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.marshalling.spi.SerializerExternalizer;

public enum SessionIDSerializer implements Serializer<SessionID>
{
    INSTANCE;


    public void write(DataOutput output, SessionID id) throws IOException {
        byte[] encoded = id.getEncodedForm();
        IndexSerializer.UNSIGNED_BYTE.writeInt(output, encoded.length);
        output.write(encoded);
    }

    public SessionID read(DataInput input) throws IOException {
        byte[] encoded = new byte[IndexSerializer.UNSIGNED_BYTE.readInt(input)];
        input.readFully(encoded);
        return SessionID.createSessionID((byte[])encoded);
    }

    public static class UUIDSessionIDExternalizer
    extends SerializerExternalizer<SessionID> {
        public UUIDSessionIDExternalizer() {
            super(UUIDSessionID.class, (Serializer)INSTANCE);
        }
    }

    public static class UnknownSessionIDExternalizer
    extends SerializerExternalizer<SessionID> {
        public UnknownSessionIDExternalizer() {
            super(UnknownSessionID.class, (Serializer)INSTANCE);
        }
    }

    public static class BasicSessionIDExternalizer
    extends SerializerExternalizer<SessionID> {
        public BasicSessionIDExternalizer() {
            super(BasicSessionID.class, (Serializer)INSTANCE);
        }
    }
}

