/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolFactoryServiceConfigurator;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum ThreadPoolResourceDefinition implements ResourceDefinitionProvider,
ThreadPoolDefinition,
ResourceServiceConfiguratorFactory
{
    DEFAULT("default", 0, 200, 0, 60000L){

        @Override
        void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
            ResourceTransformationDescriptionBuilder builder = parent.addChildResource(this.getDefinition());
            if (JGroupsModel.VERSION_6_0_0.requiresTransformation(version)) {
                for (Attribute attribute : Arrays.asList(this.getMinThreads(), this.getMaxThreads(), this.getQueueLength())) {
                    builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)attribute.getDefinition()), new String[]{attribute.getName()});
                }
            }
        }
    }
    ,
    OOB("oob", 20, 200, 0, 60000L, JGroupsModel.VERSION_6_0_0),
    INTERNAL("internal", 5, 20, 0, 60000L, JGroupsModel.VERSION_6_0_0),
    TIMER("timer", 2, 4, 0, 5000L, JGroupsModel.VERSION_6_0_0);

    static final PathElement WILDCARD_PATH;
    private final SimpleResourceDefinition definition;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute queueLength;
    private final Attribute keepAliveTime;
    private final boolean deprecated;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepAliveTime) {
        this(name, defaultMinThreads, defaultMaxThreads, defaultQueueLength, defaultKeepAliveTime, (JGroupsModel)null);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepAliveTime, JGroupsModel deprecation) {
        SimpleResourceDefinition.Parameters parameters = new SimpleResourceDefinition.Parameters(ThreadPoolResourceDefinition.pathElement(name), JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{ThreadPoolResourceDefinition.pathElement(name), ThreadPoolResourceDefinition.pathElement("*")}));
        boolean bl = this.deprecated = deprecation != null;
        if (this.deprecated) {
            parameters.setDeprecatedSince(deprecation.getVersion());
        }
        this.definition = new SimpleResourceDefinition(parameters);
        this.minThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0), deprecation).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0), deprecation).build());
        this.queueLength = new SimpleAttribute((AttributeDefinition)((SimpleAttributeDefinitionBuilder)ThreadPoolResourceDefinition.createBuilder("queue-length", ModelType.INT, new ModelNode(defaultQueueLength), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0), deprecation).setDeprecated(JGroupsModel.VERSION_6_0_0.getVersion())).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepAliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L), deprecation).build());
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder, JGroupsModel deprecation) {
        SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null));
        if (deprecation != null) {
            builder.setDeprecated(deprecation.getVersion());
        }
        return (SimpleAttributeDefinitionBuilder)builder.setValidator(validatorBuilder.configure((AbstractAttributeDefinitionBuilder)builder).build());
    }

    public ResourceDefinition getDefinition() {
        return this.definition;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this.definition);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.definition.getResourceDescriptionResolver()).addAttributes(this.getAttributes()).addAttributes(new Attribute[]{this.getQueueLength()});
        SimpleResourceServiceHandler handler = !this.deprecated ? new SimpleResourceServiceHandler((ResourceServiceConfiguratorFactory)this) : null;
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
        return new ThreadPoolFactoryServiceConfigurator(this, address);
    }

    Collection<Attribute> getAttributes() {
        return Arrays.asList(this.minThreads, this.maxThreads, this.keepAliveTime);
    }

    @Override
    public Attribute getMinThreads() {
        return this.minThreads;
    }

    @Override
    public Attribute getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    Attribute getQueueLength() {
        return this.queueLength;
    }

    void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource((ResourceDefinition)this.definition);
        if (JGroupsModel.VERSION_6_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)this.queueLength.getDefinition()), new String[]{this.queueLength.getName()});
        }
        if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
            for (Attribute attribute : Arrays.asList(this.minThreads, this.maxThreads)) {
                builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)attribute.getDefinition()), new String[]{attribute.getName()});
            }
        }
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }
}

