/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.logging.impl;

import java.util.Collection;

public final class CommaSeparatedClassesFormatter {
    private final Class<?>[] classes;

    public static String format(Class<?>[] classes) {
        return CommaSeparatedClassesFormatter.formatHighlighted(classes, -1);
    }

    public static String formatHighlighted(Class<?>[] classes, int position) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            if (position == i) {
                builder.append('*');
            }
            builder.append(classes[i].getName());
            if (position != i) continue;
            builder.append('*');
        }
        return builder.toString();
    }

    public CommaSeparatedClassesFormatter(Collection<Class<?>> classes) {
        this.classes = classes.toArray(new Class[0]);
    }

    public CommaSeparatedClassesFormatter(Class<?>[] classes) {
        this.classes = classes;
    }

    public String toString() {
        return '[' + CommaSeparatedClassesFormatter.format(this.classes) + ']';
    }
}

