/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.transaction.TransactionManager;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.logging.MDC;
import org.jboss.logging.NDC;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.ClassLoaderContextHandle;
import org.wildfly.extension.batch.jberet.deployment.ConcurrentContextHandle;
import org.wildfly.extension.batch.jberet.deployment.ContextHandle;
import org.wildfly.extension.batch.jberet.deployment.DiagnosticContextHandle;
import org.wildfly.extension.batch.jberet.deployment.NamespaceContextHandle;
import org.wildfly.extension.batch.jberet.deployment.SecurityAwareBatchEnvironment;
import org.wildfly.extension.batch.jberet.deployment.WildFlyArtifactFactory;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.transaction.client.ContextTransactionManager;

public class BatchEnvironmentService
implements Service {
    private static final Properties PROPS = new Properties();
    private final Consumer<SecurityAwareBatchEnvironment> batchEnvironmentConsumer;
    private final Supplier<WildFlyArtifactFactory> artifactFactorySupplier;
    private final Supplier<JobExecutor> jobExecutorSupplier;
    private final Supplier<RequestController> requestControllerSupplier;
    private final Supplier<JobRepository> jobRepositorySupplier;
    private final Supplier<BatchConfiguration> batchConfigurationSupplier;
    private final ClassLoader classLoader;
    private final JobXmlResolver jobXmlResolver;
    private final String deploymentName;
    private final NamespaceContextSelector namespaceContextSelector;
    private SecurityAwareBatchEnvironment batchEnvironment = null;
    private volatile ControlPoint controlPoint;

    public BatchEnvironmentService(Consumer<SecurityAwareBatchEnvironment> batchEnvironmentConsumer, Supplier<WildFlyArtifactFactory> artifactFactorySupplier, Supplier<JobExecutor> jobExecutorSupplier, Supplier<RequestController> requestControllerSupplier, Supplier<JobRepository> jobRepositorySupplier, Supplier<BatchConfiguration> batchConfigurationSupplier, ClassLoader classLoader, JobXmlResolver jobXmlResolver, String deploymentName, NamespaceContextSelector namespaceContextSelector) {
        this.batchEnvironmentConsumer = batchEnvironmentConsumer;
        this.artifactFactorySupplier = artifactFactorySupplier;
        this.jobExecutorSupplier = jobExecutorSupplier;
        this.requestControllerSupplier = requestControllerSupplier;
        this.jobRepositorySupplier = jobRepositorySupplier;
        this.batchConfigurationSupplier = batchConfigurationSupplier;
        this.classLoader = classLoader;
        this.jobXmlResolver = jobXmlResolver;
        this.deploymentName = deploymentName;
        this.namespaceContextSelector = namespaceContextSelector;
    }

    public synchronized void start(StartContext context) throws StartException {
        JobRepository jobRepository;
        JobExecutor jobExecutor;
        BatchLogger.LOGGER.debugf("Creating batch environment; %s", this.classLoader);
        BatchConfiguration batchConfiguration = this.batchConfigurationSupplier.get();
        JobExecutor jobExecutor2 = jobExecutor = this.jobExecutorSupplier != null ? this.jobExecutorSupplier.get() : null;
        if (jobExecutor == null) {
            jobExecutor = batchConfiguration.getDefaultJobExecutor();
        }
        JobRepository jobRepository2 = jobRepository = this.jobRepositorySupplier != null ? this.jobRepositorySupplier.get() : null;
        if (jobRepository == null) {
            jobRepository = batchConfiguration.getDefaultJobRepository();
        }
        this.batchEnvironment = new WildFlyBatchEnvironment(this.artifactFactorySupplier.get(), jobExecutor, (TransactionManager)ContextTransactionManager.getInstance(), jobRepository, this.jobXmlResolver);
        RequestController requestController = this.requestControllerSupplier != null ? this.requestControllerSupplier.get() : null;
        this.controlPoint = requestController != null ? requestController.getControlPoint(this.deploymentName, "batch-executor-service") : null;
        this.batchEnvironmentConsumer.accept(this.batchEnvironment);
    }

    public synchronized void stop(StopContext context) {
        this.batchEnvironmentConsumer.accept(null);
        BatchLogger.LOGGER.debugf("Removing batch environment; %s", this.classLoader);
        this.batchEnvironment = null;
        if (this.controlPoint != null) {
            this.requestControllerSupplier.get().removeControlPoint(this.controlPoint);
        }
    }

    private class WildFlyBatchEnvironment
    implements BatchEnvironment,
    SecurityAwareBatchEnvironment {
        private final WildFlyArtifactFactory artifactFactory;
        private final JobExecutor jobExecutor;
        private final TransactionManager transactionManager;
        private final JobRepository jobRepository;
        private final JobXmlResolver jobXmlResolver;

        WildFlyBatchEnvironment(WildFlyArtifactFactory artifactFactory, JobExecutor jobExecutor, TransactionManager transactionManager, JobRepository jobRepository, JobXmlResolver jobXmlResolver) {
            this.jobXmlResolver = jobXmlResolver;
            this.artifactFactory = artifactFactory;
            this.jobExecutor = jobExecutor;
            this.transactionManager = transactionManager;
            this.jobRepository = jobRepository;
        }

        public ClassLoader getClassLoader() {
            return BatchEnvironmentService.this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        public void submitTask(final JobTask jobTask) {
            final SecurityIdentity identity = this.getIdentity();
            final ContextHandle contextHandle = this.createContextHandle();
            JobTask task = new JobTask(){

                public int getRequiredRemainingPermits() {
                    return jobTask.getRequiredRemainingPermits();
                }

                public void run() {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        if (identity == null) {
                            jobTask.run();
                        } else {
                            identity.runAs((Runnable)jobTask);
                        }
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            };
            if (BatchEnvironmentService.this.controlPoint == null) {
                this.jobExecutor.execute(task);
            } else {
                BatchEnvironmentService.this.controlPoint.queueTask((Runnable)task, (Executor)this.jobExecutor, -1L, null, false);
            }
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public JobXmlResolver getJobXmlResolver() {
            return this.jobXmlResolver;
        }

        public Properties getBatchConfigurationProperties() {
            return PROPS;
        }

        public String getApplicationName() {
            return BatchEnvironmentService.this.deploymentName;
        }

        @Override
        public SecurityDomain getSecurityDomain() {
            return BatchEnvironmentService.this.batchConfigurationSupplier.get().getSecurityDomain();
        }

        private ContextHandle createContextHandle() {
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            ClassLoaderContextHandle classLoaderContextHandle = tccl == null ? new ClassLoaderContextHandle(BatchEnvironmentService.this.classLoader) : new ClassLoaderContextHandle(tccl);
            return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(BatchEnvironmentService.this.namespaceContextSelector), this.artifactFactory.createContextHandle(), new ConcurrentContextHandle(), new DiagnosticContextHandle(MDC.getMap(), NDC.get()));
        }
    }
}

