/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ManagementRegistrar;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.AuthProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.FailureDetectionProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JDBCProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemModel;
import org.jboss.as.clustering.jgroups.subsystem.LegacyFailureDetectionProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.LegacyProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.MulticastProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketDiscoveryProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jgroups.PhysicalAddress;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class ProtocolResourceRegistrar
implements ManagementRegistrar<ManagementResourceRegistration> {
    private final ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory;
    private final UnaryOperator<ResourceDescriptor> configurator;

    ProtocolResourceRegistrar(ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        this.parentServiceConfiguratorFactory = parentServiceConfiguratorFactory;
        this.configurator = UnaryOperator.identity();
    }

    ProtocolResourceRegistrar(ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory, RuntimeResourceRegistration runtimeResourceRegistration) {
        this.parentServiceConfiguratorFactory = parentServiceConfiguratorFactory;
        this.configurator = new ResourceDescriptorConfigurator(runtimeResourceRegistration);
    }

    public void register(ManagementResourceRegistration registration) {
        new GenericProtocolResourceDefinition(this.configurator, this.parentServiceConfiguratorFactory).register(registration);
        for (SocketProtocol socketProtocol : EnumSet.allOf(SocketProtocol.class)) {
            new SocketProtocolResourceDefinition(socketProtocol.name(), this.configurator, socketProtocol.getResourceServiceConfiguratorFactory(), this.parentServiceConfiguratorFactory).register(registration);
        }
        for (MulticastProtocol multicastProtocol : EnumSet.allOf(MulticastProtocol.class)) {
            new MulticastProtocolResourceDefinition(multicastProtocol.name(), this.configurator, this.parentServiceConfiguratorFactory).register(registration);
        }
        for (JdbcProtocol jdbcProtocol : EnumSet.allOf(JdbcProtocol.class)) {
            new JDBCProtocolResourceDefinition(jdbcProtocol.name(), this.configurator, this.parentServiceConfiguratorFactory).register(registration);
            new GenericProtocolResourceDefinition(jdbcProtocol.name(), JGroupsSubsystemModel.VERSION_5_0_0, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
        }
        for (EncryptProtocol encryptProtocol : EnumSet.allOf(EncryptProtocol.class)) {
            new EncryptProtocolResourceDefinition<KeyStore.Entry>(encryptProtocol.name(), encryptProtocol.entryClass, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
            new GenericProtocolResourceDefinition(encryptProtocol.name(), JGroupsSubsystemModel.VERSION_5_0_0, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
        }
        for (InitialHostsProtocol initialHostsProtocol : EnumSet.allOf(InitialHostsProtocol.class)) {
            new SocketDiscoveryProtocolResourceDefinition(initialHostsProtocol.name(), initialHostsProtocol.hostTransformer, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
            new GenericProtocolResourceDefinition(initialHostsProtocol.name(), JGroupsSubsystemModel.VERSION_5_0_0, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
        }
        for (AuthProtocol authProtocol : EnumSet.allOf(AuthProtocol.class)) {
            new AuthProtocolResourceDefinition(authProtocol.name(), this.configurator, this.parentServiceConfiguratorFactory).register(registration);
            new GenericProtocolResourceDefinition(authProtocol.name(), JGroupsSubsystemModel.VERSION_5_0_0, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
        }
        if (registration.getProcessType().isServer()) {
            for (LegacyProtocol legacyProtocol : EnumSet.allOf(LegacyProtocol.class)) {
                new LegacyProtocolResourceDefinition(legacyProtocol.name, legacyProtocol.targetName, legacyProtocol.deprecation, this.configurator, this.parentServiceConfiguratorFactory).register(registration);
            }
        }
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final RuntimeResourceRegistration runtimeResourceRegistration;

        ResourceDescriptorConfigurator(RuntimeResourceRegistration runtimeResourceRegistration) {
            this.runtimeResourceRegistration = runtimeResourceRegistration;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addRuntimeResourceRegistration(this.runtimeResourceRegistration);
        }
    }

    static enum LegacyProtocol {

        final String name;
        final String targetName;
        final JGroupsSubsystemModel deprecation;

        private LegacyProtocol(Class<? extends Protocol> targetProtocol, JGroupsSubsystemModel deprecation) {
            this(null, targetProtocol, deprecation);
        }

        private LegacyProtocol(String name, Class<? extends Protocol> targetProtocol, JGroupsSubsystemModel deprecation) {
            this.name = name != null ? name : this.name();
            this.targetName = targetProtocol.getName().substring("org.jgroups.protocols.".length());
            this.deprecation = deprecation;
        }
    }

    static enum SocketProtocol {
        FD_SOCK(LegacyFailureDetectionProtocolConfigurationServiceConfigurator::new),
        FD_SOCK2(FailureDetectionProtocolConfigurationServiceConfigurator::new);

        private final ResourceServiceConfiguratorFactory factory;

        private SocketProtocol(ResourceServiceConfiguratorFactory factory) {
            this.factory = factory;
        }

        ResourceServiceConfiguratorFactory getResourceServiceConfiguratorFactory() {
            return this.factory;
        }
    }

    static enum MulticastProtocol {
        MPING;

    }

    static enum JdbcProtocol {
        JDBC_PING;

    }

    static enum InitialHostsProtocol {
        TCPGOSSIP(InetSocketAddress.class, Function.identity()),
        TCPPING(PhysicalAddress.class, address -> new IpAddress(address.getAddress(), address.getPort()));

        final Function<InetSocketAddress, ?> hostTransformer;

        private <A> InitialHostsProtocol(Class<A> hostClass, Function<InetSocketAddress, A> hostTransformer) {
            this.hostTransformer = hostTransformer;
        }
    }

    static enum EncryptProtocol {
        ASYM_ENCRYPT(KeyStore.PrivateKeyEntry.class),
        SYM_ENCRYPT(KeyStore.SecretKeyEntry.class);

        final Class<? extends KeyStore.Entry> entryClass;

        private EncryptProtocol(Class<? extends KeyStore.Entry> entryClass) {
            this.entryClass = entryClass;
        }
    }

    static enum AuthProtocol {
        AUTH;

    }
}

