/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DomainServerUtils {
    public static Set<ServerIdentity> getAllRunningServers(ModelNode hostModel, String localHostName, Map<String, ProxyController> serverProxies) {
        return DomainServerUtils.getServersForGroup(null, hostModel, localHostName, serverProxies);
    }

    public static Set<ServerIdentity> getServersForGroup(String groupName, ModelNode hostModel, String localHostName, Map<String, ProxyController> serverProxies) {
        Set<ServerIdentity> result;
        if (hostModel.hasDefined("server-config")) {
            result = new HashSet();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                if (serverProxies.get(serverName) == null) continue;
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (groupName != null && !groupName.equals(serverGroupName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(localHostName, serverGroupName, serverName);
                result.add(groupedServer);
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    public static Set<ServerIdentity> getServersForType(String type, String ref, ModelNode domainModel, ModelNode hostModel, String localHostName, Map<String, ProxyController> serverProxies) {
        Set<String> groups = DomainServerUtils.getGroupsForType(type, ref, domainModel);
        HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
        for (String group : groups) {
            allServers.addAll(DomainServerUtils.getServersForGroup(group, hostModel, localHostName, serverProxies));
        }
        return allServers;
    }

    public static Set<String> getGroupsForType(String type, String ref, ModelNode domainModel) {
        Set<String> groups;
        if (domainModel.hasDefined("server-group")) {
            groups = new HashSet();
            for (Property prop : domainModel.get("server-group").asPropertyList()) {
                ModelNode serverGroup = prop.getValue();
                if (!ref.equals(serverGroup.get(type).asString())) continue;
                groups.add(prop.getName());
            }
        } else {
            groups = Collections.emptySet();
        }
        return groups;
    }

    public static Set<String> getRelatedElements(String containerType, String parent, String childType, String child, ModelNode domainModel) {
        HashSet<String> result = new HashSet<String>();
        result.add(parent);
        HashSet<String> checked = new HashSet<String>();
        checked.add(parent);
        ModelNode targetContainer = domainModel.get(new String[]{containerType, parent});
        if (targetContainer.hasDefined("includes")) {
            for (ModelNode include : targetContainer.get("includes").asList()) {
                checked.add(include.asString());
            }
        }
        ModelNode containerModel = domainModel.get(containerType);
        Set allContainers = containerModel.keys();
        while (checked.size() < allContainers.size()) {
            for (String name : allContainers) {
                if (checked.contains(name)) continue;
                ModelNode container = containerModel.get(name);
                if (!container.hasDefined("includes")) {
                    checked.add(name);
                    continue;
                }
                boolean allKnown = true;
                for (ModelNode include : container.get("includes").asList()) {
                    String includeName = include.asString();
                    if (result.contains(includeName)) {
                        if (container.hasDefined(childType) && container.get(childType).hasDefined(child)) break;
                        result.add(name);
                        break;
                    }
                    if (checked.contains(includeName)) continue;
                    allKnown = false;
                    break;
                }
                if (!allKnown) continue;
                checked.add(name);
            }
        }
        return result;
    }

    public static Map<String, ProxyController> getServerProxies(String localHostName, Resource domainRootResource, ImmutableManagementResourceRegistration domainRootResourceRegistration) {
        Set serverNames = domainRootResource.getChild(PathElement.pathElement((String)"host", (String)localHostName)).getChildrenNames("server-config");
        HashMap<String, ProxyController> proxies = new HashMap<String, ProxyController>();
        for (String serverName : serverNames) {
            PathAddress serverAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)localHostName), PathElement.pathElement((String)"server", (String)serverName)});
            ProxyController proxyController = domainRootResourceRegistration.getProxyController(serverAddress);
            if (proxyController == null) continue;
            proxies.put(serverName, proxyController);
        }
        return proxies;
    }
}

