/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.util.Map;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.L1InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.metadata.L1MetadataInternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

@Scope(value=Scopes.NAMED_CACHE)
public class InternalEntryFactoryImpl
implements InternalEntryFactory {
    @Inject
    TimeService timeService;

    public InternalCacheEntry create(Object key, Object value, Metadata metadata) {
        long maxIdle;
        long lifespan = metadata != null ? metadata.lifespan() : -1L;
        long l = maxIdle = metadata != null ? metadata.maxIdle() : -1L;
        if (!InternalEntryFactoryImpl.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, this.timeService.wallClockTime());
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, this.timeService.wallClockTime());
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, this.timeService.wallClockTime());
        }
        if (lifespan < 0L && maxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
    }

    public InternalCacheEntry create(CacheEntry cacheEntry) {
        if (cacheEntry.getCreated() == -1L && cacheEntry.getLastUsed() == -1L) {
            return this.create(cacheEntry.getKey(), cacheEntry.getValue(), cacheEntry.getMetadata(), cacheEntry.getLifespan(), cacheEntry.getMaxIdle());
        }
        return this.create(cacheEntry.getKey(), cacheEntry.getValue(), cacheEntry.getMetadata(), cacheEntry.getCreated(), cacheEntry.getLifespan(), cacheEntry.getLastUsed(), cacheEntry.getMaxIdle());
    }

    public InternalCacheEntry create(Object key, Object value, InternalCacheEntry cacheEntry) {
        return this.create(key, value, cacheEntry.getMetadata(), cacheEntry.getCreated(), cacheEntry.getLifespan(), cacheEntry.getLastUsed(), cacheEntry.getMaxIdle());
    }

    public InternalCacheEntry create(Object key, Object value, EntryVersion version, long created, long lifespan, long lastUsed, long maxIdle) {
        if (version == null) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, created);
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, lastUsed);
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
        }
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan).maxIdle(maxIdle).version(version).build();
        if (lifespan < 0L && maxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, created);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, lastUsed);
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, lastUsed, created);
    }

    public InternalCacheEntry create(Object key, Object value, Metadata metadata, long created, long lifespan, long lastUsed, long maxIdle) {
        if (!InternalEntryFactoryImpl.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, created);
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, lastUsed);
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
        }
        long metaLifespan = metadata.lifespan();
        long metaMaxIdle = metadata.maxIdle();
        if (metaLifespan < 0L && metaMaxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (metaLifespan > -1L && metaMaxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, created);
        }
        if (metaLifespan < 0L && metaMaxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, lastUsed);
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, lastUsed, created);
    }

    public InternalCacheValue createValue(CacheEntry cacheEntry) {
        Metadata metadata = cacheEntry.getMetadata();
        long lifespan = cacheEntry.getLifespan();
        long maxIdle = cacheEntry.getMaxIdle();
        if (!InternalEntryFactoryImpl.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheValue(cacheEntry.getValue());
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheValue(cacheEntry.getValue(), cacheEntry.getCreated(), lifespan);
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheValue(cacheEntry.getValue(), maxIdle, cacheEntry.getLastUsed());
            }
            return new TransientMortalCacheValue(cacheEntry.getValue(), cacheEntry.getCreated(), lifespan, maxIdle, cacheEntry.getLastUsed());
        }
        if (lifespan < 0L && maxIdle < 0L) {
            return new MetadataImmortalCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata());
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MetadataMortalCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata(), cacheEntry.getCreated());
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new MetadataTransientCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata(), cacheEntry.getLastUsed());
        }
        return new MetadataTransientMortalCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata(), cacheEntry.getCreated(), cacheEntry.getLastUsed());
    }

    public InternalCacheEntry create(Object key, Object value, Metadata metadata, long lifespan, long maxIdle) {
        if (!InternalEntryFactoryImpl.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, this.timeService.wallClockTime());
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, this.timeService.wallClockTime());
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, this.timeService.wallClockTime());
        }
        long metaLifespan = metadata.lifespan();
        long metaMaxIdle = metadata.maxIdle();
        if (metaLifespan < 0L && metaMaxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (metaLifespan > -1L && metaMaxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        if (metaLifespan < 0L && metaMaxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
    }

    public InternalCacheEntry update(InternalCacheEntry ice, Metadata metadata) {
        if (!InternalEntryFactoryImpl.isStoreMetadata(metadata, ice)) {
            return this.updateMetadataUnawareEntry(ice, metadata.lifespan(), metadata.maxIdle());
        }
        return this.updateMetadataAwareEntry(ice, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCacheEntry update(InternalCacheEntry cacheEntry, Object value, Metadata metadata) {
        InternalCacheEntry internalCacheEntry = cacheEntry;
        synchronized (internalCacheEntry) {
            boolean reincarnate = metadata == null || metadata.updateCreationTimestamp();
            cacheEntry.setValue(value);
            InternalCacheEntry original = cacheEntry;
            cacheEntry = this.update(cacheEntry, metadata);
            if (reincarnate && cacheEntry.getLifespan() > 0L && original == cacheEntry) {
                cacheEntry.reincarnate(this.timeService.wallClockTime());
            }
            return cacheEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry copy(CacheEntry cacheEntry) {
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            return cacheEntry.clone();
        }
    }

    public <K, V> InternalCacheEntry createL1(K key, V value, Metadata metadata) {
        if (!InternalEntryFactoryImpl.isStoreMetadata(metadata, null)) {
            return new L1InternalCacheEntry(key, value, metadata.lifespan(), this.timeService.wallClockTime());
        }
        return new L1MetadataInternalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
    }

    @Override
    public <K, V> InternalCacheValue<V> getValueFromCtx(K key, InvocationContext ctx) {
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return ((InternalCacheEntry)entry).toInternalCacheValue();
        }
        if (entry != null) {
            IncrementableEntryVersion version;
            Map<Object, IncrementableEntryVersion> updatedVersions;
            InternalCacheValue cv = this.create(entry).toInternalCacheValue();
            PrivateMetadata metadata = entry.getInternalMetadata();
            if (ctx.isInTxScope() && (updatedVersions = ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions()) != null && (version = updatedVersions.get(entry.getKey())) != null) {
                metadata = PrivateMetadata.getBuilder(metadata).entryVersion(version).build();
            }
            cv.setInternalMetadata(metadata);
            return cv;
        }
        return null;
    }

    private InternalCacheEntry updateMetadataUnawareEntry(InternalCacheEntry ice, long lifespan, long maxIdle) {
        if (lifespan < 0L) {
            if (maxIdle < 0L) {
                if (ice instanceof ImmortalCacheEntry && !(ice instanceof MetadataImmortalCacheEntry)) {
                    return ice;
                }
                return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
            }
            if (ice instanceof TransientCacheEntry) {
                ((TransientCacheEntry)ice).setMaxIdle(maxIdle);
                return ice;
            }
            return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle, this.timeService.wallClockTime());
        }
        if (maxIdle < 0L) {
            if (ice instanceof MortalCacheEntry) {
                ((MortalCacheEntry)ice).setLifespan(lifespan);
                return ice;
            }
            return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan, this.timeService.wallClockTime());
        }
        if (ice instanceof TransientMortalCacheEntry) {
            TransientMortalCacheEntry transientMortalEntry = (TransientMortalCacheEntry)ice;
            transientMortalEntry.setLifespan(lifespan);
            transientMortalEntry.setMaxIdle(maxIdle);
            return ice;
        }
        long ctm = this.timeService.wallClockTime();
        return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
    }

    private InternalCacheEntry updateMetadataAwareEntry(InternalCacheEntry ice, Metadata metadata) {
        long lifespan = metadata.lifespan();
        long maxIdle = metadata.maxIdle();
        if (lifespan < 0L) {
            if (maxIdle < 0L) {
                if (ice instanceof MetadataImmortalCacheEntry) {
                    ice.setMetadata(metadata);
                    return ice;
                }
                return new MetadataImmortalCacheEntry(ice.getKey(), ice.getValue(), metadata);
            }
            if (ice instanceof MetadataTransientCacheEntry) {
                ice.setMetadata(metadata);
                return ice;
            }
            return new MetadataTransientCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
        }
        if (maxIdle < 0L) {
            if (ice instanceof MetadataMortalCacheEntry) {
                ice.setMetadata(metadata);
                return ice;
            }
            return new MetadataMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
        }
        if (ice instanceof MetadataTransientMortalCacheEntry) {
            ice.setMetadata(metadata);
            return ice;
        }
        long ctm = this.timeService.wallClockTime();
        return new MetadataTransientMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, ctm, ctm);
    }

    public static boolean isStoreMetadata(Metadata metadata, InternalCacheEntry ice) {
        return metadata != null && (metadata.version() != null || !(metadata instanceof EmbeddedMetadata));
    }
}

