/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.reduction;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;

public class ReductionPublisherRequestCommand<K>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 31;
    private boolean parallelStream;
    private DeliveryGuarantee deliveryGuarantee;
    private IntSet segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private long explicitFlags;
    private boolean entryStream;
    private Function transformer;
    private Function finalizer;
    private int topologyId = -1;

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    private ReductionPublisherRequestCommand() {
        super(null);
    }

    public ReductionPublisherRequestCommand(ByteString cacheName) {
        super(cacheName);
    }

    public ReductionPublisherRequestCommand(ByteString cacheName, boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, long explicitFlags, boolean entryStream, Function transformer, Function finalizer) {
        super(cacheName);
        this.parallelStream = parallelStream;
        this.deliveryGuarantee = deliveryGuarantee;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.explicitFlags = explicitFlags;
        this.entryStream = entryStream;
        this.transformer = transformer;
        this.finalizer = finalizer;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (this.transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.transformer)).inject(componentRegistry);
        }
        if (this.finalizer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.finalizer)).inject(componentRegistry);
        }
        LocalPublisherManager lpm = componentRegistry.getLocalPublisherManager().running();
        if (this.entryStream) {
            return lpm.entryReduction(this.parallelStream, this.segments, this.keys, this.excludedKeys, this.explicitFlags, this.deliveryGuarantee, this.transformer, this.finalizer);
        }
        return lpm.keyReduction(this.parallelStream, this.segments, this.keys, this.excludedKeys, this.explicitFlags, this.deliveryGuarantee, this.transformer, this.finalizer);
    }

    @Override
    public byte getCommandId() {
        return 31;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeBoolean(this.parallelStream);
        MarshallUtil.marshallEnum((Enum)this.deliveryGuarantee, (ObjectOutput)output);
        output.writeObject(this.segments);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.excludedKeys, (ObjectOutput)output);
        output.writeLong(this.explicitFlags);
        output.writeBoolean(this.entryStream);
        if (this.transformer == this.finalizer) {
            output.writeBoolean(true);
        } else {
            output.writeBoolean(false);
            output.writeObject(this.transformer);
        }
        output.writeObject(this.finalizer);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.parallelStream = input.readBoolean();
        this.deliveryGuarantee = (DeliveryGuarantee)MarshallUtil.unmarshallEnum((ObjectInput)input, DeliveryGuarantee::valueOf);
        this.segments = (IntSet)input.readObject();
        this.keys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.excludedKeys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.explicitFlags = input.readLong();
        this.entryStream = input.readBoolean();
        boolean same = input.readBoolean();
        if (same) {
            this.finalizer = this.transformer = (Function)input.readObject();
        } else {
            this.transformer = (Function)input.readObject();
            this.finalizer = (Function)input.readObject();
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "PublisherRequestCommand{, flags=" + EnumUtil.prettyPrintBitSet((long)this.explicitFlags, Flag.class) + ", topologyId=" + this.topologyId + ", segments=" + this.segments + ", keys=" + Util.toStr(this.keys) + ", excludedKeys=" + Util.toStr(this.excludedKeys) + ", transformer= " + this.transformer + ", finalizer=" + this.finalizer + "}";
    }
}

