/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.faces.view;

import jakarta.faces.view.Location;
import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class LocationMarshaller
implements ProtoStreamMarshaller<Location> {
    private static final int PATH_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int COLUMN_INDEX = 3;

    public Class<? extends Location> getJavaClass() {
        return Location.class;
    }

    public Location readFrom(ProtoStreamReader reader) throws IOException {
        String path = null;
        int line = -1;
        int column = -1;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    path = reader.readString();
                    continue block5;
                }
                case 2: {
                    line = reader.readUInt32();
                    continue block5;
                }
                case 3: {
                    column = reader.readUInt32();
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new Location(path, line, column);
    }

    public void writeTo(ProtoStreamWriter writer, Location location) throws IOException {
        int column;
        int line;
        String path = location.getPath();
        if (path != null) {
            writer.writeString(1, path);
        }
        if ((line = location.getLine()) >= 0) {
            writer.writeUInt32(2, line);
        }
        if ((column = location.getColumn()) >= 0) {
            writer.writeUInt32(3, column);
        }
    }
}

