/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.transport.remote.jgroups;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.jca.core.workmanager.ClassBundle;
import org.jboss.jca.core.workmanager.WorkClassLoader;

class SecurityActions {
    private SecurityActions() {
    }

    static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    static WorkClassLoader createWorkClassLoader(final ClassBundle cb) {
        return AccessController.doPrivileged(new PrivilegedAction<WorkClassLoader>(){

            @Override
            public WorkClassLoader run() {
                return new WorkClassLoader(cb);
            }
        });
    }

    static Method getMethod(final Class<?> c, final String name, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getMethod(name, params);
        }
        Method result = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return c.getMethod(name, params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }
}

