/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.ResponseProvider;
import io.smallrye.health.SmallRyeHealthReporter;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.health.ServerProbe;
import org.wildfly.extension.health.ServerProbesService;
import org.wildfly.extension.microprofile.health.MicroProfileHealthReporter;

public class MicroProfileHealthReporterService
implements org.jboss.msc.service.Service<MicroProfileHealthReporter> {
    private static MicroProfileHealthReporter healthReporter;
    private Supplier<ServerProbesService> serverProbesService;
    private String emptyLivenessChecksStatus;
    private String emptyReadinessChecksStatus;
    private String emptyStartupChecksStatus;

    static void install(OperationContext context, String emptyLivenessChecksStatus, String emptyReadinessChecksStatus, String emptyStartupChecksStatus) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(RuntimeCapability.Builder.of((String)"org.wildfly.extension.microprofile.health.reporter", SmallRyeHealthReporter.class).build());
        Supplier serverProbesService = serviceBuilder.requires(ServiceName.parse((String)"org.wildfly.extension.health.server-probes"));
        serviceBuilder.setInstance((Service)new MicroProfileHealthReporterService(serverProbesService, emptyLivenessChecksStatus, emptyReadinessChecksStatus, emptyStartupChecksStatus)).install();
    }

    private MicroProfileHealthReporterService(Supplier<ServerProbesService> serverProbesService, String emptyLivenessChecksStatus, String emptyReadinessChecksStatus, String emptyStartupChecksStatus) {
        this.serverProbesService = serverProbesService;
        this.emptyLivenessChecksStatus = emptyLivenessChecksStatus;
        this.emptyReadinessChecksStatus = emptyReadinessChecksStatus;
        this.emptyStartupChecksStatus = emptyStartupChecksStatus;
    }

    public void start(StartContext context) {
        boolean defaultServerProceduresDisabled = ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.class).orElse(false);
        String defaultReadinessEmptyResponse = ConfigProvider.getConfig().getOptionalValue("mp.health.default.readiness.empty.response", String.class).orElse("DOWN");
        String defaultStartupEmptyResponse = ConfigProvider.getConfig().getOptionalValue("mp.health.default.startup.empty.response", String.class).orElse("DOWN");
        healthReporter = new MicroProfileHealthReporter(this.emptyLivenessChecksStatus, this.emptyReadinessChecksStatus, this.emptyStartupChecksStatus, defaultServerProceduresDisabled, defaultReadinessEmptyResponse, defaultStartupEmptyResponse);
        if (!defaultServerProceduresDisabled) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            for (ServerProbe serverProbe : this.serverProbesService.get().getServerProbes()) {
                healthReporter.addServerReadinessCheck(MicroProfileHealthReporterService.wrap(serverProbe), tccl);
            }
        }
        HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)new ResponseProvider());
    }

    public void stop(StopContext context) {
        healthReporter = null;
        HealthCheckResponse.setResponseProvider(null);
    }

    public MicroProfileHealthReporter getValue() {
        return healthReporter;
    }

    static HealthCheck wrap(final ServerProbe delegate) {
        return new HealthCheck(){

            public HealthCheckResponse call() {
                ServerProbe.Outcome outcome = delegate.getOutcome();
                HealthCheckResponseBuilder check = HealthCheckResponse.named((String)delegate.getName()).status(outcome.isSuccess());
                if (outcome.getData().isDefined()) {
                    for (Property property : outcome.getData().asPropertyList()) {
                        check.withData(property.getName(), property.getValue().asString());
                    }
                }
                return check.build();
            }
        };
    }
}

