/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.health.CheckOperations;
import org.wildfly.extension.microprofile.health.MicroProfileHealthContextService;
import org.wildfly.extension.microprofile.health.MicroProfileHealthExtension;
import org.wildfly.extension.microprofile.health.MicroProfileHealthReporter;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemAdd;

public class MicroProfileHealthSubsystemDefinition
extends PersistentResourceDefinition {
    private static final String[] ALLOWED_STATUS = new String[]{"UP", "DOWN"};
    static final String MICROPROFILE_HEALTH_REPORTER_CAPABILITY = "org.wildfly.extension.microprofile.health.reporter";
    static final String HEALTH_HTTP_CONTEXT_CAPABILITY = "org.wildfly.extension.health.http-context";
    static final String HEALTH_SERVER_PROBE_CAPABILITY = "org.wildfly.extension.health.server-probes";
    static final RuntimeCapability<Void> HEALTH_REPORTER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.microprofile.health.reporter", MicroProfileHealthReporter.class).addRequirements(new String[]{"org.wildfly.weld", "org.wildfly.extension.health.server-probes"}).build();
    public static final ServiceName HEALTH_REPORTER_SERVICE = ServiceName.parse((String)"org.wildfly.extension.microprofile.health.reporter");
    static final RuntimeCapability<Void> MICROPROFILE_HEALTH_HTTP_CONTEXT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.microprofile.health.http-context", MicroProfileHealthContextService.class).addRequirements(new String[]{"org.wildfly.extension.health.http-context"}).build();
    static final ServiceName HTTP_CONTEXT_SERVICE = MICROPROFILE_HEALTH_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName();
    static final RuntimeCapability<Void> MICROPROFILE_HEALTH_HTTP_SECURITY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.health.http-context.security-enabled", Boolean.class).build();
    static final AttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(ModelNode.TRUE)).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).build();
    static final AttributeDefinition EMPTY_LIVENESS_CHECKS_STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"empty-liveness-checks-status", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode("UP"))).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setValidator((ParameterValidator)new StringAllowedValuesValidator(ALLOWED_STATUS))).build();
    static final AttributeDefinition EMPTY_READINESS_CHECKS_STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"empty-readiness-checks-status", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode("UP"))).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setValidator((ParameterValidator)new StringAllowedValuesValidator(ALLOWED_STATUS))).build();
    static final AttributeDefinition EMPTY_STARTUP_CHECKS_STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"empty-startup-checks-status", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode("UP"))).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setValidator((ParameterValidator)new StringAllowedValuesValidator(ALLOWED_STATUS))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_ENABLED, EMPTY_LIVENESS_CHECKS_STATUS, EMPTY_READINESS_CHECKS_STATUS, EMPTY_STARTUP_CHECKS_STATUS};
    private boolean registerRuntimeOperations;

    protected MicroProfileHealthSubsystemDefinition(boolean registerRuntimeOperations) {
        super(new SimpleResourceDefinition.Parameters(MicroProfileHealthExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)MicroProfileHealthExtension.SUBSYSTEM_RESOLVER).setAddHandler((OperationStepHandler)MicroProfileHealthSubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler((AbstractAddStepHandler)MicroProfileHealthSubsystemAdd.INSTANCE)).setCapabilities(new RuntimeCapability[]{HEALTH_REPORTER_RUNTIME_CAPABILITY, MICROPROFILE_HEALTH_HTTP_CONTEXT_CAPABILITY, MICROPROFILE_HEALTH_HTTP_SECURITY_CAPABILITY}));
        this.registerRuntimeOperations = registerRuntimeOperations;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.registerRuntimeOperations) {
            CheckOperations.register(resourceRegistration);
        }
    }
}

