/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import java.util.Iterator;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class CLIAccessControl {
    private static final Logger log = Logger.getLogger(CLIAccessControl.class);

    public static boolean isExecute(ModelControllerClient client, OperationRequestAddress address, String operation) {
        return CLIAccessControl.isExecute(client, null, address, operation);
    }

    public static boolean isExecute(ModelControllerClient client, String[] parent, OperationRequestAddress address, String operation) {
        ModelNode accessControl = CLIAccessControl.getAccessControl(client, parent, address, true);
        if (accessControl == null) {
            return false;
        }
        if (!accessControl.has("default")) {
            log.warnf("access-control is missing defaults: %s", (Object)accessControl);
            return false;
        }
        ModelNode defaults = accessControl.get("default");
        if (!defaults.has("operations")) {
            log.warnf("access-control/default is missing operations: %s", (Object)defaults);
            return false;
        }
        ModelNode operations = defaults.get("operations");
        if (!operations.has(operation)) {
            log.tracef("The operation is missing in the description: %s", (Object)operation);
            return false;
        }
        ModelNode opAC = operations.get(operation);
        if (!opAC.has("execute")) {
            log.warnf("'execute' is missing for %s in %s", (Object)operation, (Object)accessControl);
            return false;
        }
        return opAC.get("execute").asBoolean();
    }

    public static ModelNode getAccessControl(ModelControllerClient client, OperationRequestAddress address, boolean operations) {
        return CLIAccessControl.getAccessControl(client, null, address, operations);
    }

    public static ModelNode getAccessControl(ModelControllerClient client, String[] parent, OperationRequestAddress address, boolean operations) {
        ModelNode response;
        if (client == null) {
            return null;
        }
        if (address.endsOnType()) {
            log.debug("The prefix ends on a type.");
            return null;
        }
        ModelNode request = new ModelNode();
        CLIAccessControl.setAddress(request, parent, address);
        request.get("operation").set("read-resource-description");
        request.get("access-control").set("trim-descriptions");
        if (operations) {
            request.get("operations").set(true);
        }
        try {
            response = client.execute(request);
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Failed to execute %s", (Object)"read-resource-description");
            return null;
        }
        if (!Util.isSuccess(response)) {
            log.debugf("Failed to execute %s:%s", (Object)"read-resource-description", (Object)response);
            return null;
        }
        if (!response.has("result")) {
            log.warnf("Response is missing result for %s:%s", (Object)"read-resource-description", (Object)response);
            return null;
        }
        ModelNode result = response.get("result");
        if (!result.has("access-control")) {
            log.warnf("Result is missing access-control for %s:%s", (Object)"read-resource-description", (Object)response);
            return null;
        }
        return result.get("access-control");
    }

    private static void setAddress(ModelNode request, String[] parent, OperationRequestAddress address) {
        ModelNode addressNode = request.get("address");
        addressNode.setEmptyList();
        if (parent != null) {
            int i = 0;
            while (i < parent.length) {
                addressNode.add(parent[i++], parent[i++]);
            }
        }
        if (!address.isEmpty()) {
            Iterator iterator = address.iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    addressNode.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new IllegalArgumentException("The node name is not specified for type '" + node.getType() + "'");
            }
        }
    }
}

