/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jboss.dmr.stream.JsonReaderImpl;
import org.jboss.dmr.stream.JsonWriterImpl;
import org.jboss.dmr.stream.ModelReader;
import org.jboss.dmr.stream.ModelReaderImpl;
import org.jboss.dmr.stream.ModelWriter;
import org.jboss.dmr.stream.ModelWriterImpl;

public final class ModelStreamFactory {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final ModelStreamFactory DMR_FACTORY = new ModelStreamFactory(false);
    private static final ModelStreamFactory JSON_FACTORY = new ModelStreamFactory(true);
    private final boolean jsonCompatible;

    private ModelStreamFactory(boolean jsonCompatible) {
        this.jsonCompatible = jsonCompatible;
    }

    public static ModelStreamFactory getInstance(boolean jsonCompatible) {
        return jsonCompatible ? JSON_FACTORY : DMR_FACTORY;
    }

    public ModelReader newModelReader(Reader reader) {
        ModelStreamFactory.assertNotNullParameter(reader);
        return this.jsonCompatible ? new JsonReaderImpl(reader) : new ModelReaderImpl(reader);
    }

    public ModelWriter newModelWriter(Writer writer) {
        ModelStreamFactory.assertNotNullParameter(writer);
        return this.jsonCompatible ? new JsonWriterImpl(writer) : new ModelWriterImpl(writer);
    }

    public ModelReader newModelReader(InputStream stream) {
        return this.newModelReader(stream, DEFAULT_CHARSET);
    }

    public ModelWriter newModelWriter(OutputStream stream) {
        return this.newModelWriter(stream, DEFAULT_CHARSET);
    }

    public ModelReader newModelReader(InputStream stream, Charset charset) {
        ModelStreamFactory.assertNotNullParameter(stream);
        ModelStreamFactory.assertNotNullParameter(charset);
        return this.newModelReader(new InputStreamReader(stream, charset));
    }

    public ModelWriter newModelWriter(OutputStream stream, Charset charset) {
        ModelStreamFactory.assertNotNullParameter(stream);
        ModelStreamFactory.assertNotNullParameter(charset);
        return this.newModelWriter(new OutputStreamWriter(stream, charset));
    }

    private static void assertNotNullParameter(Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
    }
}

