/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class FailSafeFailureHandlerWrapper
implements FailureHandler {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final FailureHandler delegate;

    public FailSafeFailureHandlerWrapper(FailureHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handle(FailureContext context) {
        try {
            this.delegate.handle(context);
        }
        catch (Throwable t) {
            log.failureInFailureHandler(t);
        }
    }

    @Override
    public void handle(EntityIndexingFailureContext context) {
        try {
            this.delegate.handle(context);
        }
        catch (Throwable t) {
            log.failureInFailureHandler(t);
        }
    }

    @Override
    public long failureFloodingThreshold() {
        try {
            return this.delegate.failureFloodingThreshold();
        }
        catch (Throwable t) {
            log.failureInFailureHandler(t);
            return FailureHandler.super.failureFloodingThreshold();
        }
    }
}

