/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.annotations.Policy;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicyAttachment;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicyAttachmentStore;

public class EndpointPolicyAttachments {
    private final Map<Policy.Placement, List<PolicyAttachment>> attachmentMap;

    private EndpointPolicyAttachments(Map<Policy.Placement, List<PolicyAttachment>> attachmentMap) {
        this.attachmentMap = attachmentMap;
    }

    public static EndpointPolicyAttachments newInstance(String[] sets, PolicyAttachmentStore store) {
        HashMap<Policy.Placement, List<PolicyAttachment>> map = new HashMap<Policy.Placement, List<PolicyAttachment>>();
        for (String set : sets) {
            List<PolicyAttachment> attachments = store.get(set);
            for (PolicyAttachment attachment : attachments) {
                Policy.Placement p = attachment.getPlacement();
                if (map.containsKey(p)) {
                    ((List)map.get(p)).add(attachment);
                    continue;
                }
                ArrayList<PolicyAttachment> list = new ArrayList<PolicyAttachment>(4);
                list.add(attachment);
                map.put(attachment.getPlacement(), list);
            }
        }
        return new EndpointPolicyAttachments(map);
    }

    public List<PolicyAttachment> getPolicyAttachments(Policy.Placement placement) {
        List<PolicyAttachment> pal = this.attachmentMap.get(placement);
        if (pal == null) {
            return Collections.emptyList();
        }
        return pal;
    }
}

