/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class Stages {
    private Stages() {
    }

    static final class Coupled
    implements Stage.Coupled {
        private final Graph subscriber;
        private final Graph publisher;

        Coupled(Graph subscriber, Graph publisher) {
            this.subscriber = Objects.requireNonNull(subscriber, "Subscriber must not be null");
            this.publisher = Objects.requireNonNull(publisher, "Publisher must not be null");
        }

        public Graph getSubscriber() {
            return this.subscriber;
        }

        public Graph getPublisher() {
            return this.publisher;
        }
    }

    static final class FromCompletionStageNullable
    implements Stage.FromCompletionStageNullable {
        private final CompletionStage<?> completionStage;

        FromCompletionStageNullable(CompletionStage<?> completionStage) {
            this.completionStage = Objects.requireNonNull(completionStage, "CompletionStage must not be null");
        }

        public CompletionStage<?> getCompletionStage() {
            return this.completionStage;
        }
    }

    static final class FromCompletionStage
    implements Stage.FromCompletionStage {
        private final CompletionStage<?> completionStage;

        FromCompletionStage(CompletionStage<?> completionStage) {
            this.completionStage = Objects.requireNonNull(completionStage, "CompletionStage must not be null");
        }

        public CompletionStage<?> getCompletionStage() {
            return this.completionStage;
        }
    }

    static final class Cancel
    implements Stage.Cancel {
        static final Stage.Cancel INSTANCE = new Cancel();

        private Cancel() {
        }
    }

    static final class Concat
    implements Stage.Concat {
        private final Graph first;
        private final Graph second;

        Concat(Graph first, Graph second) {
            this.first = first;
            this.second = second;
        }

        public Graph getFirst() {
            return this.first;
        }

        public Graph getSecond() {
            return this.second;
        }
    }

    static final class Failed
    implements Stage.Failed {
        private final Throwable error;

        Failed(Throwable error) {
            this.error = Objects.requireNonNull(error, "Exception must not be null");
        }

        public Throwable getError() {
            return this.error;
        }
    }

    static final class OnErrorResumeWith
    implements Stage.OnErrorResumeWith {
        private final Function<Throwable, Graph> function;

        OnErrorResumeWith(Function<Throwable, Graph> function) {
            this.function = Objects.requireNonNull(function, "Resume with function must be empty");
        }

        public Function<Throwable, Graph> getFunction() {
            return this.function;
        }
    }

    static final class OnErrorResume
    implements Stage.OnErrorResume {
        private final Function<Throwable, ?> function;

        OnErrorResume(Function<Throwable, ?> function) {
            this.function = Objects.requireNonNull(function, "Resume function must not be null");
        }

        public Function<Throwable, ?> getFunction() {
            return this.function;
        }
    }

    static final class OnComplete
    implements Stage.OnComplete {
        private final Runnable action;

        OnComplete(Runnable runnable) {
            this.action = Objects.requireNonNull(runnable, "Action must not be null");
        }

        public Runnable getAction() {
            return this.action;
        }
    }

    static final class OnTerminate
    implements Stage.OnTerminate {
        private final Runnable action;

        OnTerminate(Runnable runnable) {
            this.action = Objects.requireNonNull(runnable, "Action must not be null");
        }

        public Runnable getAction() {
            return this.action;
        }
    }

    static final class OnError
    implements Stage.OnError {
        private final Consumer<Throwable> consumer;

        OnError(Consumer<Throwable> consumer) {
            this.consumer = Objects.requireNonNull(consumer, "Consumer must not be null");
        }

        public Consumer<Throwable> getConsumer() {
            return this.consumer;
        }
    }

    static final class FlatMapIterable
    implements Stage.FlatMapIterable {
        private final Function<?, Iterable<?>> mapper;

        FlatMapIterable(Function<?, Iterable<?>> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "Mapper function must not be null");
        }

        public Function<?, Iterable<?>> getMapper() {
            return this.mapper;
        }
    }

    static final class FlatMapCompletionStage
    implements Stage.FlatMapCompletionStage {
        private final Function<?, CompletionStage<?>> mapper;

        FlatMapCompletionStage(Function<?, CompletionStage<?>> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "Mapper function must not be null");
        }

        public Function<?, CompletionStage<?>> getMapper() {
            return this.mapper;
        }
    }

    static final class FlatMap
    implements Stage.FlatMap {
        private final Function<?, Graph> mapper;

        FlatMap(Function<?, Graph> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "Mapper function must not be null");
        }

        public Function<?, Graph> getMapper() {
            return this.mapper;
        }
    }

    static final class Collect
    implements Stage.Collect {
        private final Collector<?, ?, ?> collector;

        Collect(Collector<?, ?, ?> collector) {
            this.collector = Objects.requireNonNull(collector, "Collector must not be null");
        }

        public Collector<?, ?, ?> getCollector() {
            return this.collector;
        }
    }

    static final class SubscriberStage
    implements Stage.SubscriberStage {
        private final Subscriber<?> subscriber;

        SubscriberStage(Subscriber<?> subscriber) {
            this.subscriber = Objects.requireNonNull(subscriber, "Subscriber must not be null");
        }

        public Subscriber<?> getRsSubscriber() {
            return this.subscriber;
        }
    }

    static final class FindFirst
    implements Stage.FindFirst {
        static final Stage.FindFirst INSTANCE = new FindFirst();

        private FindFirst() {
        }
    }

    static final class ProcessorStage
    implements Stage.ProcessorStage {
        private final Processor<?, ?> processor;

        ProcessorStage(Processor<?, ?> processor) {
            this.processor = Objects.requireNonNull(processor, "Processor must not be null");
        }

        public Processor<?, ?> getRsProcessor() {
            return this.processor;
        }
    }

    static final class Of
    implements Stage.Of {
        static final Stage.Of EMPTY = new Of(Collections.emptyList());
        private final Iterable<?> elements;

        Of(Iterable<?> elements) {
            this.elements = Objects.requireNonNull(elements, "Iterable must not be null");
        }

        public Iterable<?> getElements() {
            return this.elements;
        }
    }

    static final class PublisherStage
    implements Stage.PublisherStage {
        private final Publisher<?> publisher;

        PublisherStage(Publisher<?> publisher) {
            this.publisher = Objects.requireNonNull(publisher, "Publisher must not be null");
        }

        public Publisher<?> getRsPublisher() {
            return this.publisher;
        }
    }

    static final class TakeWhile
    implements Stage.TakeWhile {
        private final Predicate<?> predicate;

        TakeWhile(Predicate<?> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Predicate must not be null");
        }

        public Predicate<?> getPredicate() {
            return this.predicate;
        }
    }

    static final class Distinct
    implements Stage.Distinct {
        static final Stage.Distinct INSTANCE = new Distinct();

        private Distinct() {
        }
    }

    static final class Limit
    implements Stage.Limit {
        private final long limit;

        Limit(long limit) {
            if (limit < 0L) {
                throw new IllegalArgumentException("Cannot limit a stream to less than zero elements.");
            }
            this.limit = limit;
        }

        public long getLimit() {
            return this.limit;
        }
    }

    static final class Skip
    implements Stage.Skip {
        private final long skip;

        Skip(long skip) {
            if (skip < 0L) {
                throw new IllegalArgumentException("Cannot skip less than zero elements");
            }
            this.skip = skip;
        }

        public long getSkip() {
            return this.skip;
        }
    }

    static final class DropWhile
    implements Stage.DropWhile {
        private final Predicate<?> predicate;

        DropWhile(Predicate<?> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Predicate must not be null");
        }

        public Predicate<?> getPredicate() {
            return this.predicate;
        }
    }

    static final class Filter
    implements Stage.Filter {
        private final Predicate<?> predicate;

        Filter(Predicate<?> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Predicate must not be null");
        }

        public Predicate<?> getPredicate() {
            return this.predicate;
        }
    }

    static final class Peek
    implements Stage.Peek {
        private final Consumer<?> consumer;

        Peek(Consumer<?> consumer) {
            this.consumer = Objects.requireNonNull(consumer, "Consumer must not be null");
        }

        public Consumer<?> getConsumer() {
            return this.consumer;
        }
    }

    static final class Map
    implements Stage.Map {
        private final Function<?, ?> mapper;

        Map(Function<?, ?> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "Mapper function must not be null");
        }

        public Function<?, ?> getMapper() {
            return this.mapper;
        }
    }
}

