/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.PasswordAction;

@Command(name="add", description="Add a new user")
public class AddUser
extends PasswordAction {
    @Option(name={"--plaintext"}, description="store the password in plaintext (Default: false)")
    boolean plaintext = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.checkInputUser();
        this.checkInputPassword();
        this.checkInputRole();
        this.add();
        return null;
    }

    private void add() throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"addUser", (Object[])new Object[]{AddUser.this.userCommandUser, AddUser.this.userCommandPassword, AddUser.this.role, AddUser.this.plaintext});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                ((AddUser)AddUser.this).getActionContext().out.println(AddUser.this.userCommandUser + " added successfully.");
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                ((AddUser)AddUser.this).getActionContext().err.println("Failed to add user " + AddUser.this.userCommandUser + ". Reason: " + errMsg);
            }
        });
    }
}

