/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.hibernate.search.mapper.orm.bootstrap.impl.ExtendedBeanManagerSynchronizer;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmIntegrationPartialBuildState;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooter;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.mapper.orm.spi.EnvironmentSynchronizer;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.IndexView;

public class HibernateOrmIntegrationBooterImpl
implements HibernateOrmIntegrationBooter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Metadata metadata;
    private final IndexView jandexIndex;
    private final ReflectionManager reflectionManager;
    private final ValueHandleFactory valueHandleFactory;
    private final HibernateSearchPreIntegrationService preIntegrationService;
    private final Optional<EnvironmentSynchronizer> environmentSynchronizer;

    private HibernateOrmIntegrationBooterImpl(BuilderImpl builder) {
        this.metadata = builder.metadata;
        StandardServiceRegistry serviceRegistry = builder.bootstrapContext.getServiceRegistry();
        this.jandexIndex = builder.bootstrapContext.getJandexView();
        this.reflectionManager = builder.bootstrapContext.getReflectionManager();
        this.valueHandleFactory = builder.valueHandleFactory != null ? builder.valueHandleFactory : ValueHandleFactory.usingMethodHandle((MethodHandles.Lookup)MethodHandles.publicLookup());
        this.preIntegrationService = HibernateOrmUtils.getServiceOrFail((ServiceRegistry)serviceRegistry, HibernateSearchPreIntegrationService.class);
        Optional<EnvironmentSynchronizer> providedEnvironmentSynchronizer = HibernateOrmUtils.getServiceOrEmpty((ServiceRegistry)serviceRegistry, EnvironmentSynchronizer.class);
        if (providedEnvironmentSynchronizer.isPresent()) {
            this.environmentSynchronizer = providedEnvironmentSynchronizer;
        } else {
            ConfigurationService ormConfigurationService = HibernateOrmUtils.getServiceOrFail((ServiceRegistry)serviceRegistry, ConfigurationService.class);
            Object unknownBeanManager = ormConfigurationService.getSettings().get("javax.persistence.bean.manager");
            if (unknownBeanManager == null) {
                unknownBeanManager = ormConfigurationService.getSettings().get("jakarta.persistence.bean.manager");
            }
            if (unknownBeanManager instanceof ExtendedBeanManager) {
                ExtendedBeanManager extendedBeanManager = (ExtendedBeanManager)unknownBeanManager;
                ExtendedBeanManagerSynchronizer synchronizer = new ExtendedBeanManagerSynchronizer();
                extendedBeanManager.registerLifecycleListener((ExtendedBeanManager.LifecycleListener)synchronizer);
                this.environmentSynchronizer = Optional.of(synchronizer);
            } else {
                this.environmentSynchronizer = Optional.empty();
            }
        }
    }

    @Override
    public void preBoot(BiConsumer<String, Object> propertyCollector) {
        if (this.environmentSynchronizer.isPresent()) {
            throw new AssertionFailure("Cannot pre-boot when an environment synchronizer is used to delay Hibernate Search's bootstrap:  we cannot both delay bootstrap and perform it earlier.");
        }
        this.preIntegrationService.doBootFirstPhase(this.metadata, this.jandexIndex, this.reflectionManager, this.valueHandleFactory).set(propertyCollector);
    }

    CompletableFuture<HibernateSearchContextProviderService> orchestrateBootAndShutdown(CompletionStage<SessionFactoryImplementor> sessionFactoryReadyStage, CompletionStage<?> sessionFactoryDestroyingStage) {
        CompletableFuture<HibernateSearchContextProviderService> contextFuture = new CompletableFuture<HibernateSearchContextProviderService>();
        CompletableFuture environmentSynchronizerReadyStage = new CompletableFuture();
        CompletableFuture environmentSynchronizerStartedDestroyingStage = new CompletableFuture();
        if (this.environmentSynchronizer.isPresent()) {
            this.environmentSynchronizer.get().whenEnvironmentDestroying(() -> environmentSynchronizerStartedDestroyingStage.complete(null));
            this.environmentSynchronizer.get().whenEnvironmentReady(() -> {
                environmentSynchronizerReadyStage.complete(null);
                if (contextFuture.isCompletedExceptionally()) {
                    Futures.unwrappedExceptionJoin((CompletableFuture)contextFuture);
                }
            });
        } else {
            environmentSynchronizerReadyStage.complete(null);
        }
        CompletionStage bootRequiredStage = environmentSynchronizerReadyStage.thenCombine(sessionFactoryReadyStage, (ignored, sessionFactory) -> sessionFactory);
        CompletableFuture<Object> shutdownRequiredStage = CompletableFuture.anyOf(environmentSynchronizerStartedDestroyingStage, sessionFactoryDestroyingStage.toCompletableFuture());
        ((CompletableFuture)((CompletableFuture)bootRequiredStage).thenApply(this::bootNow)).whenComplete(Futures.copyHandler(contextFuture));
        shutdownRequiredStage.thenRun(() -> HibernateOrmIntegrationBooterImpl.lambda$orchestrateBootAndShutdown$3((CompletableFuture)bootRequiredStage));
        ((CompletableFuture)((CompletableFuture)contextFuture.exceptionally(throwable -> null)).thenAcceptBoth(shutdownRequiredStage, (context, ignored) -> {
            if (context != null) {
                context.close();
            }
        })).whenComplete(Futures.handler((ignored, throwable) -> {
            if (throwable != null) {
                log.shutdownFailed(throwable.getMessage(), (Throwable)throwable);
            }
        }));
        return contextFuture;
    }

    private HibernateSearchContextProviderService bootNow(SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateOrmIntegrationPartialBuildState partialBuildState = this.preIntegrationService.doBootFirstPhase(this.metadata, this.jandexIndex, this.reflectionManager, this.valueHandleFactory);
        try {
            return partialBuildState.doBootSecondPhase(sessionFactoryImplementor, this.preIntegrationService.propertySource(), this.preIntegrationService.propertyChecker());
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(HibernateOrmIntegrationPartialBuildState::closeOnFailure, (Object)partialBuildState);
            throw e;
        }
    }

    private static /* synthetic */ void lambda$orchestrateBootAndShutdown$3(CompletableFuture bootRequiredStage) {
        bootRequiredStage.cancel(false);
    }

    public static class BuilderImpl
    implements HibernateOrmIntegrationBooter.Builder {
        private final Metadata metadata;
        private final BootstrapContext bootstrapContext;
        private ValueHandleFactory valueHandleFactory;

        public BuilderImpl(Metadata metadata, BootstrapContext bootstrapContext) {
            this.metadata = metadata;
            this.bootstrapContext = bootstrapContext;
        }

        @Override
        public HibernateOrmIntegrationBooter.Builder valueReadHandleFactory(ValueHandleFactory valueHandleFactory) {
            this.valueHandleFactory = valueHandleFactory;
            return this;
        }

        @Override
        public HibernateOrmIntegrationBooterImpl build() {
            return new HibernateOrmIntegrationBooterImpl(this);
        }
    }
}

