/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ServletInfo;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.security.PrivilegedActionException;
import java.util.function.Function;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.wildfly.elytron.web.undertow.server.servlet.IdentityMapping;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

class RunAsLifecycleInterceptor
implements LifecycleInterceptor {
    private final Function<String, RunAsIdentityMetaData> runAsMapper;
    private final SecurityDomain securityDomain;

    RunAsLifecycleInterceptor(Function<String, RunAsIdentityMetaData> runAsMapper, SecurityDomain securityDomain) {
        this.runAsMapper = runAsMapper;
        this.securityDomain = securityDomain;
    }

    private void doIt(ServletInfo servletInfo, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        RunAsIdentityMetaData runAsMetaData = this.runAsMapper.apply(servletInfo.getName());
        if (runAsMetaData != null) {
            SecurityIdentity securityIdentity = IdentityMapping.performMapping(this.securityDomain.getAnonymousSecurityIdentity(), this.securityDomain, runAsMetaData);
            try {
                securityIdentity.runAs(() -> {
                    context.proceed();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ServletException) {
                    throw (ServletException)cause;
                }
                throw new ServletException(cause);
            }
        } else {
            context.proceed();
        }
    }

    public void init(ServletInfo servletInfo, Servlet servlet, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        this.doIt(servletInfo, context);
    }

    public void init(FilterInfo filterInfo, Filter filter, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        context.proceed();
    }

    public void destroy(ServletInfo servletInfo, Servlet servlet, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        this.doIt(servletInfo, context);
    }

    public void destroy(FilterInfo filterInfo, Filter filter, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        context.proceed();
    }
}

