/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.IdentifierMarshallerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum SessionIdentifierMarshaller implements ScalarMarshaller<String>
{
    INSTANCE;

    private final Marshaller<String, ByteBuffer> marshaller = SessionIdentifierMarshaller.loadMarshaller();

    private static Marshaller<String, ByteBuffer> loadMarshaller() {
        Iterator<IdentifierMarshallerProvider> providers = SessionIdentifierMarshaller.load(IdentifierMarshallerProvider.class).iterator();
        if (!providers.hasNext()) {
            throw new ServiceConfigurationError(IdentifierMarshallerProvider.class.getName());
        }
        return providers.next().getMarshaller();
    }

    private static <T> Iterable<T> load(final Class<T> providerClass) {
        PrivilegedAction action = new PrivilegedAction<Iterable<T>>(){

            @Override
            public Iterable<T> run() {
                return ServiceLoader.load(providerClass, providerClass.getClassLoader());
            }
        };
        return (Iterable)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    public String readFrom(ProtoStreamReader reader) throws IOException {
        return (String)this.marshaller.read((Object)reader.readByteBuffer());
    }

    public void writeTo(ProtoStreamWriter writer, String id) throws IOException {
        ByteBuffer buffer = (ByteBuffer)this.marshaller.write((Object)id);
        int offset = buffer.arrayOffset();
        int length = buffer.limit() - offset;
        writer.writeVarint32(length);
        writer.writeRawBytes(buffer.array(), offset, length);
    }

    public Class<? extends String> getJavaClass() {
        return String.class;
    }

    public WireType getWireType() {
        return WireType.LENGTH_DELIMITED;
    }
}

