/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.net.Inet;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum InetAddressMarshaller implements FieldSetMarshaller<InetAddress, InetAddress>,
ParametricPrivilegedExceptionAction<InetAddress, String>
{
    INSTANCE;

    private static final InetAddress DEFAULT;
    private static final int HOST_NAME_INDEX = 0;
    private static final int ADDRESS_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public InetAddress getBuilder() {
        return DEFAULT;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public InetAddress readField(ProtoStreamReader reader, int index, InetAddress address) throws IOException {
        switch (index) {
            case 0: {
                try {
                    return (InetAddress)WildFlySecurityManager.doUnchecked((Object)reader.readString(), (ParametricPrivilegedExceptionAction)this);
                }
                catch (PrivilegedActionException e) {
                    Exception exception = e.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IllegalStateException(e);
                }
            }
            case 1: {
                return InetAddress.getByAddress(reader.readByteArray());
            }
        }
        return address;
    }

    @Override
    public void writeFields(ProtoStreamWriter writer, int startIndex, InetAddress address) throws IOException {
        String hostName = Inet.getHostNameIfResolved((InetAddress)address);
        if (hostName != null) {
            if (!hostName.equals(DEFAULT.getHostName())) {
                writer.writeString(startIndex + 0, hostName);
            }
        } else {
            byte[] bytes = address.getAddress();
            if (!Arrays.equals(bytes, DEFAULT.getAddress())) {
                writer.writeBytes(startIndex + 1, address.getAddress());
            }
        }
    }

    public InetAddress run(String host) throws UnknownHostException {
        return InetAddress.getByName(host);
    }

    static {
        DEFAULT = InetAddress.getLoopbackAddress();
    }
}

